/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.activitymarket.box.schemas;

import com.google.gson.annotations.SerializedName;
import io.intino.consul.activitymarket.box.schemas.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Activity
implements Serializable {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="version")
    private String version;
    @SerializedName(value="url")
    private String url;
    @SerializedName(value="manifest")
    private Manifest manifest;

    public String id() {
        return this.id;
    }

    public String version() {
        return this.version;
    }

    public String url() {
        return this.url;
    }

    public Manifest manifest() {
        return this.manifest;
    }

    public Activity id(String id) {
        this.id = id;
        return this;
    }

    public Activity version(String version) {
        this.version = version;
        return this;
    }

    public Activity url(String url) {
        this.url = url;
        return this;
    }

    public Activity manifest(Manifest manifest) {
        this.manifest = manifest;
        return this;
    }

    public static class Manifest
    implements Serializable {
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="description")
        private String description;
        @SerializedName(value="parameters")
        private List<Parameter> parameters = new ArrayList<Parameter>();
        @SerializedName(value="service")
        private Service service;

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }

        public List<Parameter> parameters() {
            return this.parameters;
        }

        public Service service() {
            return this.service;
        }

        public Manifest name(String name) {
            this.name = name;
            return this;
        }

        public Manifest description(String description) {
            this.description = description;
            return this;
        }

        public Manifest parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Manifest service(Service service) {
            this.service = service;
            return this;
        }

        public static class Service
        implements Serializable {
            @SerializedName(value="endpoint")
            private List<Endpoint> endpoint = new ArrayList<Endpoint>();

            public List<Endpoint> endpointList() {
                return this.endpoint;
            }

            public List<Endpoint> endpointList(Predicate<Endpoint> predicate) {
                return this.endpoint.stream().filter(predicate).collect(Collectors.toList());
            }

            public Endpoint endpoint(Predicate<Endpoint> predicate) {
                return this.endpoint.stream().filter(predicate).findFirst().orElse(null);
            }

            public Service endpointList(List<Endpoint> endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public static class Endpoint
            implements Serializable {
                @SerializedName(value="name")
                private String name;
                @SerializedName(value="description")
                private String description;
                @SerializedName(value="parameters")
                private List<Parameter> parameters = new ArrayList<Parameter>();
                @SerializedName(value="response")
                private Response response;

                public String name() {
                    return this.name;
                }

                public String description() {
                    return this.description;
                }

                public List<Parameter> parameters() {
                    return this.parameters;
                }

                public Response response() {
                    return this.response;
                }

                public Endpoint name(String name) {
                    this.name = name;
                    return this;
                }

                public Endpoint description(String description) {
                    this.description = description;
                    return this;
                }

                public Endpoint parameters(List<Parameter> parameters) {
                    this.parameters = parameters;
                    return this;
                }

                public Endpoint response(Response response) {
                    this.response = response;
                    return this;
                }

                public static class Response
                implements Serializable {
                    @SerializedName(value="type")
                    private String type;
                    @SerializedName(value="description")
                    private String description;

                    public String type() {
                        return this.type;
                    }

                    public String description() {
                        return this.description;
                    }

                    public Response type(String type) {
                        this.type = type;
                        return this;
                    }

                    public Response description(String description) {
                        this.description = description;
                        return this;
                    }
                }
            }
        }
    }
}

