/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.activitymarket.box;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.restaccessor.OutBox;
import io.intino.alexandria.restaccessor.RequestBuilder;
import io.intino.alexandria.restaccessor.Response;
import io.intino.alexandria.restaccessor.adapters.RequestAdapter;
import io.intino.alexandria.restaccessor.adapters.ResponseAdapter;
import io.intino.alexandria.restaccessor.core.RestAccessorNotifier;
import io.intino.consul.activitymarket.box.schemas.Activity;
import io.intino.consul.activitymarket.box.schemas.ActivityInfo;
import io.intino.consul.activitymarket.box.schemas.Container;
import java.io.File;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiAccessor {
    private final URL url;
    private final RestAccessorNotifier notifier = new RestAccessorNotifier();
    private int timeoutMillis = 120000;
    private OutBox outBox = null;
    private Map<String, String> additionalHeaders = new HashMap<String, String>();

    public ApiAccessor(URL url) {
        this.url = url;
    }

    public ApiAccessor(URL url, int timeoutMillis) {
        this.url = url;
        this.timeoutMillis = timeoutMillis;
    }

    public ApiAccessor(URL url, int timeoutMillis, File outBoxDirectory, int intervalRetrySeconds) {
        this.url = url;
        this.timeoutMillis = timeoutMillis;
        this.outBox = new OutBox(outBoxDirectory, intervalRetrySeconds);
    }

    public void addCommonHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
    }

    public void addRequestSerializer(Type type, JsonSerializer<?> adapter) {
        RequestAdapter.addCustomAdapter((Type)type, adapter);
    }

    public void addResponseDeserializer(Type type, JsonDeserializer<?> adapter) {
        ResponseAdapter.addCustomAdapter((Type)type, adapter);
    }

    public List<ActivityInfo> getActivities() throws InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.build(RequestBuilder.Method.GET, "/api/activities");
        try {
            Response response = request.execute();
            return (List)ResponseAdapter.adapt((String)response.content(), (Type)new TypeToken<ArrayList<ActivityInfo>>(){}.getType());
        }
        catch (AlexandriaException e) {
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public List<String> getContainerVersions() throws InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.build(RequestBuilder.Method.GET, "/api/container/versions");
        try {
            Response response = request.execute();
            return (List)ResponseAdapter.adapt((String)response.content(), (Type)new TypeToken<ArrayList<String>>(){}.getType());
        }
        catch (AlexandriaException e) {
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public Container getContainer(String version) throws InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.build(RequestBuilder.Method.GET, "/api/container/" + version);
        try {
            Response response = request.execute();
            return (Container)ResponseAdapter.adapt((String)response.content(), Container.class);
        }
        catch (AlexandriaException e) {
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public Activity getActivity(String name, String version) throws InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.build(RequestBuilder.Method.GET, "/api/activity/" + name + "/" + version);
        try {
            Response response = request.execute();
            return (Activity)ResponseAdapter.adapt((String)response.content(), Activity.class);
        }
        catch (AlexandriaException e) {
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }
}

