/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.accessor;

import com.google.gson.reflect.TypeToken;
import io.intino.alexandria.Json;
import io.intino.alexandria.jms.QueueProducer;
import io.intino.alexandria.logger.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;

public class ConsulAccessor
implements Closeable {
    private static final Type asList = new TypeToken<List<String>>(){}.getType();
    private static final Type asMap = new TypeToken<Map<String, String>>(){}.getType();
    private static final Type asBooleanMap = new TypeToken<Map<String, Boolean>>(){}.getType();
    private static final int DefaultTimeoutSeconds = 10;
    private static final String PATH = "service.consul.%s.request";
    private final Session session;
    private final Map<String, Message> inbox;
    private final Map<String, Object> waiting;
    private Destination temporaryQueue;
    private MessageConsumer consumer;
    private QueueProducer producer;

    public ConsulAccessor(Session session, String serverID) {
        this.session = session;
        this.inbox = new HashMap<String, Message>();
        this.waiting = new HashMap<String, Object>();
        try {
            this.temporaryQueue = session.createTemporaryQueue();
            this.consumer = session.createConsumer(this.temporaryQueue);
            this.consumer.setMessageListener(this.messageDispatcher());
            this.producer = new QueueProducer(session, String.format(PATH, serverID));
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
        }
    }

    public boolean upgrade(String version, InputStream source, Map<String, String> args) {
        try {
            HashMap<String, String> map = new HashMap<String, String>(args);
            map.put("version", version);
            Message message = this.createBytesMessage(this.temporaryQueue, source.readAllBytes(), "container#upgrade", map);
            Message response = this.request(message, 10);
            return response != null && Boolean.parseBoolean(((TextMessage)response).getText());
        }
        catch (IOException | JMSException e) {
            Logger.warn((String)("Error in response: " + e.getMessage()));
            return false;
        }
    }

    public boolean restart() {
        try {
            TextMessage message = this.createMessage(this.temporaryQueue, "container#restart");
            Message response = this.request((Message)message, 10);
            return response != null && Boolean.parseBoolean(((TextMessage)response).getText());
        }
        catch (JMSException e) {
            Logger.warn((String)("Error in response: " + e.getMessage()));
            return false;
        }
    }

    public Map<String, Boolean> activities() {
        try {
            TextMessage message = this.createMessage(this.temporaryQueue, "container#activities");
            Message response = this.request((Message)message, 10);
            return response == null ? Collections.emptyMap() : (Map)Json.fromJson((String)((TextMessage)response).getText(), (Type)asBooleanMap);
        }
        catch (JMSException e) {
            Logger.warn((String)("Error in response: " + e.getMessage()));
            return Collections.emptyMap();
        }
    }

    public Map<String, String> getActivityConfiguration(String activityId) {
        try {
            Message message = this.createMessage(this.temporaryQueue, "container#configurationActivity", Map.of("activity", activityId));
            Message response = this.request(message, 10);
            if (response == null) {
                return null;
            }
            return (Map)Json.fromJson((String)((TextMessage)response).getText(), (Type)asMap);
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public boolean updateActivityConfiguration(String activityId, Map<String, String> args) {
        try {
            HashMap<String, String> map = new HashMap<String, String>(args);
            map.put("activity", activityId);
            Message message = this.createMessage(this.temporaryQueue, "container#updateConfigurationActivity", map);
            Message response = this.request(message, 10);
            return response != null && Boolean.parseBoolean(((TextMessage)response).getText());
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    public boolean installActivity(String activityId, InputStream source) {
        try {
            Message message = this.createBytesMessage(this.temporaryQueue, source.readAllBytes(), "container#installActivity", Map.of("activity", activityId));
            Message response = this.request(message, 10);
            return response != null && Boolean.parseBoolean(((TextMessage)response).getText());
        }
        catch (IOException | JMSException e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    public boolean enableActivity(String activityId) {
        try {
            Message message = this.createMessage(this.temporaryQueue, "container#enableActivity", Map.of("activity", activityId));
            Message response = this.request(message, 10);
            return response != null && Boolean.parseBoolean(((TextMessage)response).getText());
        }
        catch (JMSException e) {
            Logger.warn((String)("Error in response: " + e.getMessage()));
            return false;
        }
    }

    public boolean disableActivity(String activityId) {
        try {
            Message message = this.createMessage(this.temporaryQueue, "container#disableActivity", Map.of("activity", activityId));
            Message response = this.request(message, 10);
            return response != null && Boolean.parseBoolean(((TextMessage)response).getText());
        }
        catch (JMSException e) {
            Logger.warn((String)("Error in response: " + e.getMessage()));
            return false;
        }
    }

    public boolean uninstallActivity(String activityId) {
        try {
            Message message = this.createMessage(this.temporaryQueue, "container#uninstallActivity", Map.of("activity", activityId));
            Message response = this.request(message, 10);
            return response != null && Boolean.parseBoolean(((TextMessage)response).getText());
        }
        catch (JMSException e) {
            Logger.warn((String)("Error in response: " + e.getMessage()));
            return false;
        }
    }

    private Message request(Message message, int timeoutSeconds) throws JMSException {
        String messageId = message.getJMSCorrelationID();
        Object monitor = new Object();
        this.waiting.put(messageId, monitor);
        this.producer.produce(message);
        this.waitForResponse(monitor, messageId, timeoutSeconds);
        return this.inbox.remove(messageId);
    }

    private TextMessage createMessage(Destination temporaryQueue, String request) throws JMSException {
        TextMessage message = this.session.createTextMessage();
        message.setJMSReplyTo(temporaryQueue);
        message.setStringProperty("request", request);
        message.setJMSCorrelationID(ConsulAccessor.createRandomString());
        return message;
    }

    private Message createMessage(Destination temporaryQueue, String request, Map<String, String> parameters) throws JMSException {
        TextMessage message = this.session.createTextMessage();
        return ConsulAccessor.customize(temporaryQueue, request, parameters, (Message)message);
    }

    private Message createBytesMessage(Destination temporaryQueue, byte[] content, String request, Map<String, String> parameters) throws JMSException {
        BytesMessage message = this.session.createBytesMessage();
        message.writeBytes(content);
        ConsulAccessor.customize(temporaryQueue, request, parameters, (Message)message);
        return message;
    }

    private static Message customize(Destination temporaryQueue, String request, Map<String, String> parameters, Message message) throws JMSException {
        message.setJMSReplyTo(temporaryQueue);
        message.setStringProperty("request", request);
        message.setStringProperty("parameters", Json.toJson(parameters));
        message.setJMSCorrelationID(ConsulAccessor.createRandomString());
        return message;
    }

    private static String createRandomString() {
        Random random = new Random(System.currentTimeMillis());
        long randomLong = random.nextLong();
        return Long.toHexString(randomLong);
    }

    private MessageListener messageDispatcher() {
        return message -> {
            block5: {
                try {
                    this.inbox.put(message.getJMSCorrelationID(), message);
                    Object object = this.waiting.get(message.getJMSCorrelationID());
                    if (object == null) break block5;
                    Object object2 = object;
                    synchronized (object2) {
                        object.notify();
                    }
                }
                catch (JMSException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForResponse(Object monitor, String messageId, long timeoutSeconds) {
        try {
            Object object = monitor;
            synchronized (object) {
                monitor.wait(timeoutSeconds * 1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.waiting.remove(messageId);
    }

    @Override
    public void close() {
        try {
            this.consumer.close();
            this.producer.close();
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
        }
    }
}

