/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=ThreadConfigurationService.class)
public class ThreadConfigurationService {
    @Requirement
    private Logger logger;
    private final int cpuCores;

    public ThreadConfigurationService() {
        this.cpuCores = Runtime.getRuntime().availableProcessors();
    }

    public ThreadConfigurationService(Logger logger2, int cpuCores) {
        this.logger = logger2;
        this.cpuCores = cpuCores;
    }

    public ExecutorService getExecutorService(String threadCountConfiguration, boolean perCoreThreadCount, int largestBuildListSize) {
        Integer threadCount = this.getThreadCount(threadCountConfiguration, perCoreThreadCount, largestBuildListSize);
        return this.getExecutorService(threadCount);
    }

    private ExecutorService getExecutorService(Integer threadCount) {
        if (threadCount == null) {
            this.logger.info("Building with unlimited threads");
            return Executors.newCachedThreadPool();
        }
        this.logger.info("Building with " + threadCount + " threads");
        return Executors.newFixedThreadPool(threadCount);
    }

    Integer getThreadCount(String threadCountConfiguration, boolean perCoreThreadCount, int largestBuildListSize) {
        float threadCount = Math.min(this.cpuCores, largestBuildListSize);
        if (threadCountConfiguration != null) {
            try {
                threadCount = Float.parseFloat(threadCountConfiguration);
            }
            catch (NumberFormatException e) {
                this.logger.warn("Couldn't parse thread count, will default to " + threadCount + ": " + threadCountConfiguration);
            }
        }
        if (perCoreThreadCount) {
            threadCount *= (float)this.cpuCores;
        }
        int endResult = Math.round(threadCount);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Thread pool size: " + endResult);
        }
        return endResult;
    }
}

