/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageReader;
import io.intino.cesar.datahub.events.consul.process.ProcessStatus;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.ProcessStatusAction;
import io.intino.consul.box.service.RequestAttendant;

public class ProcessStatusRequest
implements RequestAttendant {
    private final ConsulBox box;

    public ProcessStatusRequest(ConsulBox box) {
        this.box = box;
    }

    @Override
    public String responseTo(String request) {
        try {
            ProcessStatus status = this.actionFor(this.processId(request)).execute();
            return status.toString();
        }
        catch (Throwable e) {
            Logger.error(e);
            return e.getMessage();
        }
    }

    private String processId(String request) {
        return new MessageReader(request).next().get("processId").asString();
    }

    private ProcessStatusAction actionFor(String processId) {
        ProcessStatusAction action = new ProcessStatusAction();
        action.box = this.box;
        action.processId = processId;
        return action;
    }
}

