/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.process;

import io.intino.alexandria.logger.Logger;
import io.intino.cesar.datahub.events.DeployResult;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.consul.box.Utils;
import io.intino.consul.box.oshi.OSValidator;
import io.intino.consul.box.process.ProcessDeployer;
import io.intino.consul.box.process.ProcessHandler;
import io.intino.consul.box.process.RestartProcessOnStop;
import io.intino.consul.box.process.unix.LinuxProcessHandler;
import io.intino.consul.box.process.unix.LinuxProcessLogger;
import io.intino.consul.box.process.win.WinProcessHandler;
import io.intino.consul.box.process.win.WinProcessLogger;
import io.intino.consul.model.Process;
import java.io.File;
import java.util.List;

public class ProcessManager {
    private final ConsulBox box;
    private final ConsulConfiguration conf;

    public ProcessManager(ConsulBox box) {
        this.box = box;
        this.conf = box.configuration();
    }

    public DeployResult deploy(Process process) {
        try {
            this.stop(process);
            List<File> result = new ProcessDeployer(process, this.conf, this.box.localRepository()).deploy();
            process.runFile(result.get(0).getName()).processHandler(ProcessManager.createProcessHandler(this.box, process)).save$();
            return new DeployResult().success(true).debugPort(process.debugPort()).managementPort(process.managementPort()).remarks("Deployed successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.error(e.getClass().getSimpleName() + ":" + e.getMessage());
            return new DeployResult().success(false).debugPort(process.debugPort()).managementPort(process.managementPort()).remarks(e.getMessage());
        }
    }

    public boolean start(Process process) {
        if (process == null || !process.deployed()) {
            return false;
        }
        if (this.isRunning(process)) {
            return true;
        }
        try {
            if (process.processHandler() == null) {
                process.processHandler(ProcessManager.createProcessHandler(this.box, process));
            }
            int pid = process.processHandler().start();
            process.pid(pid).status(Process.Status.Running).save$();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean debug(Process process) {
        if (process == null || !process.deployed()) {
            return false;
        }
        try {
            this.stop(process);
            Thread.sleep(1000L);
            if (process.processHandler() == null) {
                process.processHandler(ProcessManager.createProcessHandler(this.box, process));
            }
            int pid = process.processHandler().debug();
            process.pid(pid).status(Process.Status.Debug).save$();
            return true;
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                e.printStackTrace();
            } else {
                Logger.error(e.getClass().getSimpleName() + ":" + e.getMessage());
            }
            return false;
        }
    }

    public boolean stop(Process process) {
        if (process == null) {
            return false;
        }
        if (process.processHandler() != null) {
            process.processHandler().stop();
            Logger.info("Process " + process.identifier() + " stopped");
            return true;
        }
        return false;
    }

    public boolean retract(Process process) {
        if (process != null) {
            this.reset(process);
            new File(this.box.logsDirectory(), process.logFileName()).delete();
            Utils.removeDirectory(new File(this.conf.applicationsDirectory(), process.appDirectoryName()));
            process.delete$();
            return true;
        }
        return false;
    }

    public boolean restart(Process process) {
        try {
            this.stop(process);
            Thread.sleep(1000L);
            this.start(process);
            return true;
        }
        catch (Exception e) {
            Logger.error(e);
            return false;
        }
    }

    public boolean reset(Process process) {
        if (process != null) {
            this.stop(process);
            ProcessHandler processHandler = process.processHandler();
            if (processHandler != null) {
                this.removeAppHomeDirectory(process);
            }
            return true;
        }
        return false;
    }

    public boolean isRunning(Process process) {
        return process != null && process.processHandler() != null && process.processHandler().isRunning();
    }

    public int exitValue(Process process) {
        return process != null && process.processHandler() != null ? process.processHandler().exitValue() : -1000;
    }

    private void removeAppHomeDirectory(Process process) {
        File appHomeDirectory = new File(this.conf.applicationsWorkspace(), process.appDirectoryName());
        appHomeDirectory.renameTo(new File(appHomeDirectory.getParentFile(), appHomeDirectory.getName() + "_" + System.currentTimeMillis() / 1000L));
    }

    public static ProcessHandler createProcessHandler(ConsulBox box, Process process) {
        return OSValidator.isUnix() ? new LinuxProcessHandler(process, box.configuration(), (LinuxProcessLogger)box.logHandler()) : new WinProcessHandler(process, box.configuration(), (WinProcessLogger)box.logHandler(), new RestartProcessOnStop(box));
    }
}

