/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.mapp;

import io.intino.alexandria.mapp.MappReader;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class Mapp {
    private final int size;
    private final String name;
    private final String[] values;
    private final List<String> labels;
    private Entry[] entries;

    public Mapp(File file) throws IOException {
        this(new MappReader(file));
    }

    public Mapp(MappReader reader) {
        this.values = reader.labels.toArray(new String[0]);
        this.size = reader.size;
        this.name = reader.name();
        this.labels = reader.labels();
        this.entries = this.readEntries(reader);
        reader.close();
    }

    public List<String> labels() {
        return this.labels;
    }

    public int size() {
        return this.size;
    }

    public String name() {
        return this.name;
    }

    public String get(long key) {
        int i = this.indexOf(key);
        if (i < 0) {
            return null;
        }
        return this.values[this.entries[i].value];
    }

    private Entry[] readEntries(MappReader reader) {
        Entry[] entries = new Entry[this.size];
        for (int i = 0; i < this.size; ++i) {
            entries[i] = reader.entryReader.readEntry();
        }
        return entries;
    }

    private int indexOf(long key) {
        int low = 0;
        int high = this.entries.length - 1;
        while (low <= high) {
            int i = low + high >>> 1;
            long cmp = this.entries[i].key - key;
            if (cmp == 0L) {
                return i;
            }
            if (cmp < 0L) {
                low = i + 1;
                continue;
            }
            high = i - 1;
        }
        return -1;
    }

    static class Entry {
        long key;
        int value;

        Entry(long key, int value) {
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            return Long.hashCode(this.key);
        }
    }
}

