/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ingestion;

import io.intino.alexandria.Fingerprint;
import io.intino.alexandria.Session;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.ingestion.SessionHandler;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.xerial.snappy.SnappyOutputStream;

public class EventSession {
    private final Map<Fingerprint, MessageWriter> writers = new ConcurrentHashMap<Fingerprint, MessageWriter>();
    private final SessionHandler.Provider provider;
    private final int autoFlush;
    private final AtomicInteger count = new AtomicInteger();

    public EventSession(SessionHandler.Provider provider) {
        this(provider, 1000000);
    }

    public EventSession(SessionHandler.Provider provider, int autoFlush) {
        this.provider = provider;
        this.autoFlush = autoFlush;
    }

    public void put(String tank, Timetag timetag, Event ... events) {
        this.put(tank, timetag, Arrays.stream(events));
        if (this.count.addAndGet(events.length) >= this.autoFlush) {
            this.flush();
        }
    }

    public void put(String tank, Timetag timetag, Stream<Event> eventStream) {
        this.put(this.writerOf(tank, timetag), eventStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            Iterator<MessageWriter> iterator = this.writers.values().iterator();
            while (iterator.hasNext()) {
                MessageWriter w;
                MessageWriter messageWriter = w = iterator.next();
                synchronized (messageWriter) {
                    w.flush();
                }
            }
            this.count.set(0);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        try {
            Iterator<MessageWriter> iterator = this.writers.values().iterator();
            while (iterator.hasNext()) {
                MessageWriter w;
                MessageWriter messageWriter = w = iterator.next();
                synchronized (messageWriter) {
                    w.close();
                }
            }
            return;
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(MessageWriter writer, Stream<Event> events) {
        MessageWriter messageWriter = writer;
        synchronized (messageWriter) {
            events.forEach(e -> this.write(writer, (Event)e));
        }
    }

    private void write(MessageWriter writer, Event event) {
        try {
            writer.write(event.toMessage());
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private MessageWriter writerOf(String tank, Timetag timetag) {
        return this.writerOf(Fingerprint.of(tank, timetag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageWriter writerOf(Fingerprint fingerprint) {
        Map<Fingerprint, MessageWriter> map = this.writers;
        synchronized (map) {
            if (!this.writers.containsKey(fingerprint)) {
                this.writers.put(fingerprint, this.createWriter(fingerprint));
            }
            return this.writers.get(fingerprint);
        }
    }

    private MessageWriter createWriter(Fingerprint fingerprint) {
        return new MessageWriter(this.snappyStream(this.provider.outputStream(fingerprint.name(), Session.Type.event)));
    }

    private SnappyOutputStream snappyStream(OutputStream outputStream) {
        return new SnappyOutputStream(outputStream, this.autoFlush * 100);
    }
}

