/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.converters;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.spi.TypeConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlexusDateTypeConverter
extends AbstractMatcher<TypeLiteral<?>>
implements TypeConverter,
Module {
    private static final DateFormat[] PLEXUS_DATE_FORMATS;
    private static final String CONVERSION_ERROR = "Cannot convert: \"%s\" to: %s";

    @Override
    public void configure(Binder binder) {
        binder.convertToTypes(this, this);
    }

    @Override
    public boolean matches(TypeLiteral<?> type) {
        return Date.class == type.getRawType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object convert(String value, TypeLiteral<?> toType) {
        for (DateFormat f : PLEXUS_DATE_FORMATS) {
            try {
                DateFormat dateFormat = f;
                synchronized (dateFormat) {
                    return f.parse(value);
                }
            }
            catch (ParseException e) {
            }
        }
        throw new IllegalArgumentException(String.format(CONVERSION_ERROR, value, Date.class));
    }

    static {
        for (DateFormat f : PLEXUS_DATE_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.S a"), new SimpleDateFormat("yyyy-MM-dd hh:mm:ssa"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")}) {
            f.setLenient(false);
        }
    }
}

