/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.framework.utils;

import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.NativeCode;
import java.lang.reflect.Field;
import java.util.logging.Logger;

public class NativeExtractor {
    public static NativeCode extract(String fieldName, Layer layer) {
        try {
            Class<?> aClass = layer.getClass();
            Field declaredField = NativeExtractor.declaredField(fieldName, aClass);
            while (declaredField == null && (aClass = aClass.getSuperclass()) != null) {
                declaredField = NativeExtractor.declaredField(fieldName, aClass);
            }
            boolean previousAccessibility = declaredField.isAccessible();
            declaredField.setAccessible(true);
            NativeCode result = (NativeCode)declaredField.get(layer);
            declaredField.setAccessible(previousAccessibility);
            return result;
        }
        catch (Exception e) {
            Logger.getGlobal().severe("Failed to extract the class from a native: " + e.getCause().getMessage());
            return null;
        }
    }

    private static Field declaredField(String fieldName, Class<? extends Layer> aClass) {
        for (Field field : aClass.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }
}

