/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageReader;
import io.intino.alexandria.terminal.Connector;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.RestartProcessAction;

public class RestartProcessRequest
implements Connector.MessageConsumer {
    private final ConsulBox box;

    public RestartProcessRequest(ConsulBox box) {
        this.box = box;
    }

    @Override
    public void accept(String request, String callback) {
        try {
            this.box.datahubConnector().sendMessage(callback, this.actionFor(this.processId(request)).execute().toString());
        }
        catch (Throwable e) {
            Logger.error(e);
        }
    }

    private String processId(String request) {
        return new MessageReader(request).next().get("processId").asString();
    }

    private RestartProcessAction actionFor(String processId) {
        RestartProcessAction action = new RestartProcessAction();
        action.box = this.box;
        action.processId = processId;
        return action;
    }
}

