/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.message.Fields;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.Parser;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageCast {
    private static final Map<Class<?>, String> classNames = new HashMap();
    private static final Map<String, Field> fields = new HashMap<String, Field>();
    private final Message message;

    private MessageCast(Message message) {
        this.message = message;
    }

    private <T> Object fillObject(Message message, Class<T> aClass, Object object) throws IllegalAccessException {
        this.fillAttributes(message, aClass, object);
        this.fillComponents(message, aClass, object);
        return object;
    }

    private <T> void fillAttributes(Message message, Class<T> aClass, Object object) throws IllegalAccessException {
        for (String attribute : message.attributes()) {
            Field field = MessageCast.fieldByName(aClass, attribute);
            if (field == null) continue;
            this.setField(field, object, this.valueOf(message, attribute, field));
        }
    }

    private Object valueOf(Message message, String attribute, Field field) {
        return this.parserOf(field).parse(message.get(attribute).toString());
    }

    private <T> void fillComponents(Message message, Class<T> aClass, Object object) throws IllegalAccessException {
        for (Message component : message.components()) {
            Field field = MessageCast.fieldByName(aClass, component.type());
            if (field == null) continue;
            this.setField(field, object, this.fillObject(component, MessageCast.classOf(field), MessageCast.create(MessageCast.classOf(field))));
        }
    }

    private void setField(Field field, Object owner, Object value) throws IllegalAccessException {
        field.setAccessible(true);
        if (this.isEnum(field)) {
            field.set(owner, Enum.valueOf(field.getType().asSubclass(Enum.class), (String)value));
        } else if (this.isList(field)) {
            field.set(owner, value instanceof List ? MessageCast.append((List)field.get(owner), (List)value) : MessageCast.append((List)field.get(owner), value));
        } else if (this.isArray(field)) {
            field.set(owner, MessageCast.append((Object[])field.get(owner), (Object[])value));
        } else {
            field.set(owner, value);
        }
    }

    private Parser parserOf(Field field) {
        return this.isList(field) ? this.parserOf(field.getGenericType().toString()) : this.parserOf(this.isEnum(field) ? String.class : field.getType());
    }

    private boolean isEnum(Field field) {
        return field.getType().isEnum();
    }

    private boolean isArray(Field field) {
        return field.getType().isArray();
    }

    private boolean isList(Field field) {
        return field.getType().isAssignableFrom(List.class);
    }

    private Parser parserOf(Class<?> type) {
        return Parser.of(type);
    }

    private Parser parserOf(final String name) {
        return new Parser(){
            final Parser parser = Parser.of(this.arrayClass());

            private Class<?> arrayClass() {
                try {
                    String className = "[L" + name.substring(name.indexOf(60) + 1).replace(">", "") + ";";
                    return Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }

            @Override
            public Object parse(String text) {
                Object[] array = (Object[])this.parser.parse(text);
                return array != null ? Arrays.asList(array) : Collections.emptyList();
            }
        };
    }

    public <T> T as(Class<T> aClass) throws IllegalAccessException {
        return (T)(this.message != null ? this.fillObject(this.message, aClass, MessageCast.create(aClass)) : null);
    }

    public static MessageCast cast(Message message) {
        return new MessageCast(message);
    }

    private static Object append(Object[] current, Object[] value) {
        if (current == null) {
            current = new Object[]{};
        }
        System.arraycopy(current, 0, value, 0, current.length);
        return value;
    }

    private static List<?> append(List current, Object value) {
        if (current == null) {
            current = new ArrayList<Object>();
        }
        current.add(value);
        return current;
    }

    private static List<?> append(List current, List value) {
        if (current == null) {
            current = new ArrayList();
        }
        current.addAll(value);
        return current;
    }

    private static <T> Field fieldByName(Class<T> aClass, String attr) {
        String attrId = MessageCast.className(aClass) + attr.toLowerCase();
        if (!fields.containsKey(attrId)) {
            MessageCast.findField(aClass, attr, attrId);
        }
        return fields.get(attrId);
    }

    private static <T> void findField(Class<T> aClass, String attr, String attrId) {
        for (Field field : Fields.of(aClass)) {
            if (!attr.equalsIgnoreCase(field.getName()) && !attr.equalsIgnoreCase(MessageCast.simpleClassName(field))) continue;
            fields.put(attrId, field);
            break;
        }
    }

    private static String simpleClassName(Field field) {
        Class<?> aClass = MessageCast.classOf(field);
        String name = MessageCast.className(aClass);
        name = name.contains("$") ? name.substring(name.lastIndexOf("$") + 1) : name;
        name = name.contains(".") ? name.substring(name.lastIndexOf(".") + 1) : name;
        return name;
    }

    private static String className(Class<?> aClass) {
        if (!classNames.containsKey(aClass)) {
            classNames.put(aClass, aClass.getCanonicalName());
        }
        return classNames.get(aClass);
    }

    private static Class<?> classOf(Field field) {
        if (!(field.getGenericType() instanceof ParameterizedType)) {
            return field.getType();
        }
        ParameterizedType type = (ParameterizedType)field.getGenericType();
        return (Class)type.getActualTypeArguments()[0];
    }

    private static Object create(Class<?> type) {
        try {
            return type.getDeclaredConstructors()[0].newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

