/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.util.sorting;

import io.intino.alexandria.led.GenericTransaction;
import io.intino.alexandria.led.LedHeader;
import io.intino.alexandria.led.LedReader;
import io.intino.alexandria.led.LedStream;
import io.intino.alexandria.led.allocators.stack.StackAllocator;
import io.intino.alexandria.led.allocators.stack.StackAllocators;
import io.intino.alexandria.led.util.iterators.MergedIterator;
import io.intino.alexandria.led.util.iterators.StatefulIterator;
import io.intino.alexandria.led.util.memory.MemoryUtils;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.stream.Stream;

public class LedExternalMergeSort {
    private static final int DEFAULT_NUM_TRANSACTIONS_IN_MEMORY = 100000;
    private double start = 0.0;

    public void sort(File srcFile, File destFile) {
        this.sort(srcFile.getParentFile(), srcFile, destFile, 100000);
    }

    public void sort(File srcFile, File destFile, int numTransactionsInMemory) {
        this.sort(srcFile.getParentFile(), srcFile, destFile, numTransactionsInMemory);
    }

    public void sort(File tempDirectory, File srcFile, File destFile, int numTransactionsInMemory) {
        try {
            this.start = System.currentTimeMillis();
            ChunkCreationInfo chunkCreationInfo = this.createSortedChunks(tempDirectory, srcFile, numTransactionsInMemory);
            this.mergeSortedChunks(chunkCreationInfo, destFile);
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    private ChunkCreationInfo createSortedChunks(File tempDir, File srcFile, int numTransactionsInMemory) {
        ChunkCreationInfo chunkCreationInfo;
        block9: {
            FileChannel fileChannel = FileChannel.open(srcFile.toPath(), StandardOpenOption.READ);
            try {
                Path chunkDir = Files.createDirectory(tempDir.toPath().resolve("ChunksFolder_" + System.nanoTime()), new FileAttribute[0]);
                String srcFileName = srcFile.getName();
                LedHeader header = Objects.requireNonNull(LedHeader.from(fileChannel));
                int transactionSize = header.elementSize();
                int chunkSize = numTransactionsInMemory * transactionSize;
                int numChunks = Math.round((float)header.elementCount() / (float)chunkSize);
                ArrayDeque<Path> chunks = new ArrayDeque<Path>(numChunks);
                ByteBuffer buffer = MemoryUtils.allocBuffer(chunkSize);
                ByteBuffer tempBuffer = MemoryUtils.allocBuffer(chunkSize);
                StackAllocator<GenericTransaction> allocator = StackAllocators.newManaged(transactionSize, buffer, GenericTransaction::new);
                PriorityQueue<GenericTransaction> priorityQueue = new PriorityQueue<GenericTransaction>(numTransactionsInMemory);
                int i = 0;
                while (fileChannel.position() < fileChannel.size()) {
                    Path chunk = Files.createFile(chunkDir.resolve("Chunk[" + i + "]_" + srcFileName), new FileAttribute[0]);
                    int bytesRead = fileChannel.read(buffer.position(0).limit(chunkSize));
                    buffer.clear();
                    this.writeSortedChunk(chunk, transactionSize, chunkSize, buffer, tempBuffer, allocator, priorityQueue, bytesRead);
                    chunks.add(chunk);
                    priorityQueue.clear();
                    allocator.clear();
                    ++i;
                }
                priorityQueue.clear();
                allocator.clear();
                MemoryUtils.free(tempBuffer);
                chunkCreationInfo = new ChunkCreationInfo(header, chunkDir, chunks, chunkSize, buffer);
                if (fileChannel == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.error(e);
                    throw new RuntimeException(e);
                }
            }
            fileChannel.close();
        }
        return chunkCreationInfo;
    }

    private void writeSortedChunk(Path chunk, int transactionSize, int chunkSize, ByteBuffer buffer, ByteBuffer tempBuffer, StackAllocator<GenericTransaction> allocator, PriorityQueue<GenericTransaction> priorityQueue, int elementsRead) {
        try (FileChannel fileChannel = FileChannel.open(chunk, StandardOpenOption.WRITE);){
            this.sortChunk(tempBuffer, allocator, priorityQueue, transactionSize, elementsRead);
            fileChannel.write(tempBuffer);
            tempBuffer.clear();
        }
        catch (IOException e) {
            Logger.error(e);
            throw new RuntimeException(e);
        }
    }

    private void sortChunk(ByteBuffer tempBuffer, StackAllocator<GenericTransaction> allocator, PriorityQueue<GenericTransaction> priorityQueue, int transactionSize, int bytesRead) {
        for (int i = 0; i < bytesRead; i += transactionSize) {
            priorityQueue.add(allocator.malloc());
        }
        long tempBufferPtr = MemoryUtils.addressOf(tempBuffer);
        long offset = 0L;
        while (!priorityQueue.isEmpty()) {
            GenericTransaction transaction = priorityQueue.poll();
            MemoryUtils.memcpy(transaction.address() + transaction.baseOffset(), tempBufferPtr + offset, transactionSize);
            offset += (long)transactionSize;
        }
        tempBuffer.clear();
    }

    private void mergeSortedChunks(ChunkCreationInfo chunkCreationInfo, File destFile) throws IOException {
        Queue<Path> chunks = chunkCreationInfo.sortedChunkFiles;
        Path dir = chunkCreationInfo.chunkDirectory;
        ByteBuffer buffer = chunkCreationInfo.buffer();
        int transactionSize = chunkCreationInfo.ledHeader.elementSize();
        int chunkSize = chunkCreationInfo.chunkSize / 2;
        ByteBuffer tempBuffer = MemoryUtils.allocBuffer(chunkCreationInfo.chunkSize);
        int count = 0;
        while (chunks.size() > 2) {
            Path chunk1 = chunks.remove();
            Path chunk2 = chunks.remove();
            Path mergedChunk = Files.createFile(dir.resolve("Chunk_" + count + "_merged_with_" + (count + 1) + ".led.tmp"), new FileAttribute[0]);
            MergedIterator<ChunkIterator.TransactionWrapper> mergedIterator = this.merge(chunk1, chunk2, buffer, transactionSize, chunkSize);
            this.writeSortedToMergedChunk(mergedChunk, mergedIterator, tempBuffer);
            this.deleteChunks(chunk1, chunk2);
            chunks.add(mergedChunk);
            count += 2;
        }
        MemoryUtils.free(chunkCreationInfo.buffer);
        this.doFinalMergeAndWriteToDestFile(destFile, chunks.remove(), chunks.remove(), chunkCreationInfo.ledHeader);
    }

    private void deleteChunks(Path chunk1, Path chunk2) {
        File chunkFile1 = chunk1.toFile();
        File chunkFile2 = chunk2.toFile();
        chunkFile1.deleteOnExit();
        chunkFile1.delete();
        chunkFile2.deleteOnExit();
        chunkFile2.delete();
    }

    private void checkSorting(Path chunk, int transactionSize) {
        long lastId = Long.MAX_VALUE;
        ByteBuffer buffer = MemoryUtils.allocBuffer(transactionSize);
        int count = 0;
        try (FileChannel fileChannel = FileChannel.open(chunk, StandardOpenOption.READ);){
            fileChannel.read(buffer);
            buffer.clear();
            long id = buffer.getLong(0);
            if (id > lastId) {
                throw new AssertionError((Object)(chunk + " => " + count + ": id > lastId => " + id + " > " + lastId));
            }
            lastId = id;
            ++count;
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void doFinalMergeAndWriteToDestFile(File destFile, Path chunk1, Path chunk2, LedHeader ledHeader) {
        int elementSize = ledHeader.elementSize();
        LedStream.merged(Stream.of(this.readChunk(chunk1, elementSize), this.readChunk(chunk2, elementSize))).serialize(destFile);
        this.deleteChunks(chunk1, chunk2);
        this.deleteDir(chunk1.getParent());
    }

    private void deleteDir(Path dir) {
        File dirFile = dir.toFile();
        dirFile.delete();
        dirFile.deleteOnExit();
    }

    private LedStream<GenericTransaction> readChunk(Path chunk, int elementSize) {
        try {
            return new LedReader(Files.newInputStream(chunk, new OpenOption[0])).readUncompressed(elementSize, GenericTransaction::new);
        }
        catch (IOException e) {
            Logger.error(e);
            throw new RuntimeException(e);
        }
    }

    private void writeSortedToMergedChunk(Path mergedChunk, MergedIterator<ChunkIterator.TransactionWrapper> iterator, ByteBuffer tempBuffer) {
        try (FileChannel fileChannel = FileChannel.open(mergedChunk, StandardOpenOption.WRITE);){
            long tempBufferPtr = MemoryUtils.addressOf(tempBuffer);
            long offset = 0L;
            while (iterator.hasNext()) {
                ChunkIterator.TransactionWrapper transaction = iterator.next();
                ByteBuffer buffer = transaction.buffer();
                MemoryUtils.memcpy(MemoryUtils.addressOf(buffer) + (long)transaction.offset, tempBufferPtr + offset, transaction.size());
                if ((offset += (long)transaction.size()) != (long)tempBuffer.capacity()) continue;
                fileChannel.write(tempBuffer);
                tempBuffer.clear();
                offset = 0L;
            }
        }
        catch (IOException e) {
            Logger.error(e);
            throw new RuntimeException(e);
        }
    }

    private MergedIterator<ChunkIterator.TransactionWrapper> merge(Path chunk1, Path chunk2, ByteBuffer buffer, int elementSize, int chunkSize) {
        return new MergedIterator<ChunkIterator.TransactionWrapper>(Stream.of(new ChunkIterator(chunk1, buffer, elementSize, 0, chunkSize), new ChunkIterator(chunk2, buffer, elementSize, chunkSize, chunkSize)), Comparator.naturalOrder());
    }

    private String time() {
        double time = (double)System.currentTimeMillis() - this.start;
        return " " + time / 1000.0 + " seconds";
    }

    private static final class ChunkCreationInfo {
        private final LedHeader ledHeader;
        private final Path chunkDirectory;
        private final Queue<Path> sortedChunkFiles;
        private final int chunkSize;
        private final ByteBuffer buffer;

        public ChunkCreationInfo(LedHeader ledHeader, Path chunkDirectory, Queue<Path> sortedChunkFiles, int chunkSize, ByteBuffer buffer) {
            this.ledHeader = ledHeader;
            this.chunkDirectory = chunkDirectory;
            this.sortedChunkFiles = sortedChunkFiles;
            this.chunkSize = chunkSize;
            this.buffer = buffer;
        }

        public ByteBuffer buffer() {
            return this.buffer.position(0).limit(this.chunkSize);
        }
    }

    private static class ChunkIterator
    implements StatefulIterator<TransactionWrapper> {
        private final FileChannel fileChannel;
        private final int transactionSize;
        private final long fileSize;
        private final ByteBuffer buffer;
        private TransactionWrapper current;
        private long filePosition;
        private int bufferPosition;
        private final int bufferBaseOffset;
        private final int chunkSize;
        private boolean requestReadNextChunk;
        private int transactionPosition;

        public ChunkIterator(Path file, ByteBuffer buffer, int transactionSize, int bufferBaseOffset, int chunkSize) {
            this.bufferBaseOffset = bufferBaseOffset;
            try {
                this.fileChannel = this.open(file);
                this.fileSize = this.fileChannel.size();
                this.buffer = buffer;
                this.chunkSize = chunkSize;
                this.transactionSize = transactionSize;
                this.readNextChunk();
            }
            catch (Exception e) {
                Logger.error(e);
                throw new RuntimeException(e);
            }
        }

        @Override
        public TransactionWrapper current() {
            return this.current;
        }

        @Override
        public boolean hasNext() {
            return this.transactionPosition < this.chunkSize;
        }

        @Override
        public TransactionWrapper next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.requestReadNextChunk) {
                this.readNextChunk();
                this.requestReadNextChunk = false;
            }
            this.current = new TransactionWrapper(this.bufferBaseOffset + this.bufferPosition);
            this.advanceToNextElement();
            return this.current;
        }

        private void advanceToNextElement() {
            if (this.bufferPosition >= this.chunkSize && this.filePosition < this.fileSize) {
                this.requestReadNextChunk = true;
            } else {
                this.bufferPosition += this.transactionSize;
                this.transactionPosition += this.transactionSize;
            }
        }

        private void readNextChunk() {
            if (this.filePosition >= this.fileSize) {
                throw new IndexOutOfBoundsException();
            }
            try {
                this.bufferPosition = 0;
                this.buffer.position(this.bufferBaseOffset).limit(this.bufferBaseOffset + this.chunkSize);
                this.filePosition += (long)this.fileChannel.read(this.buffer);
                this.buffer.clear();
                this.current = null;
            }
            catch (IOException e) {
                Logger.error(e);
                throw new RuntimeException(e);
            }
        }

        private FileChannel open(Path file) throws IOException {
            return FileChannel.open(file, StandardOpenOption.READ);
        }

        private final class TransactionWrapper
        implements Comparable<TransactionWrapper> {
            private final int offset;

            public TransactionWrapper(int offset) {
                this.offset = offset;
            }

            public long id() {
                return ChunkIterator.this.buffer.getLong(this.offset);
            }

            public int size() {
                return ChunkIterator.this.transactionSize;
            }

            public ByteBuffer buffer() {
                return ChunkIterator.this.buffer;
            }

            @Override
            public int compareTo(TransactionWrapper o) {
                return Long.compare(this.id(), o.id());
            }
        }
    }
}

