/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.util.memory;

import io.intino.alexandria.led.util.memory.AllocationInfo;
import io.intino.alexandria.led.util.memory.Configuration;
import io.intino.alexandria.led.util.memory.DummyNativeMemoryTracker;
import io.intino.alexandria.led.util.memory.NativeMemoryTracker;
import io.intino.alexandria.led.util.memory.NativeMemoryTrackerImpl;
import io.intino.alexandria.logger.Logger;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.function.Consumer;
import sun.misc.Unsafe;

public final class MemoryUtils {
    public static final long NULL = 0L;
    private static final Unsafe UNSAFE;
    private static final Class<? extends ByteBuffer> DIRECT_BUFFER_CLASS;
    private static final long BUFFER_ADDRESS_OFFSET;
    private static final long BUFFER_POSITION_OFFSET;
    private static final long BUFFER_MARK_OFFSET;
    private static final long BUFFER_CAPACITY_OFFSET;
    private static final long BUFFER_LIMIT_OFFSET;
    public static final Configuration<ByteOrder> DEFAULT_BYTE_ORDER;
    public static final Configuration<Boolean> USE_MEMORY_TRACKER;
    public static final Configuration<Consumer<Long>> BEFORE_ALLOCATION_CALLBACK;
    public static final Configuration<Consumer<AllocationInfo>> ALLOCATION_CALLBACK;
    public static final Configuration<Consumer<AllocationInfo>> FREE_CALLBACK;
    private static final Configuration<NativeMemoryTracker> MEMORY_TRACKER;

    public static boolean useMemoryTracker() {
        if (USE_MEMORY_TRACKER.isEmpty()) {
            USE_MEMORY_TRACKER.set(false);
        }
        return USE_MEMORY_TRACKER.get();
    }

    public static NativeMemoryTracker getMemoryTracker() {
        if (MEMORY_TRACKER.isEmpty()) {
            if (MemoryUtils.useMemoryTracker()) {
                MEMORY_TRACKER.set(new NativeMemoryTrackerImpl());
            } else {
                MEMORY_TRACKER.set(new DummyNativeMemoryTracker());
            }
        }
        return MEMORY_TRACKER.get();
    }

    public static ByteOrder defaultByteOrder() {
        if (DEFAULT_BYTE_ORDER.isEmpty()) {
            DEFAULT_BYTE_ORDER.set(ByteOrder.nativeOrder());
        }
        return DEFAULT_BYTE_ORDER.get();
    }

    public static MappedByteBuffer map(FileChannel fileChannel, FileChannel.MapMode mode, long baseOffset, long size) {
        try {
            MappedByteBuffer mappedByteBuffer = fileChannel.map(mode, baseOffset, size);
            mappedByteBuffer.order(MemoryUtils.defaultByteOrder());
            return mappedByteBuffer;
        }
        catch (Exception e) {
            Logger.error(e);
            throw new RuntimeException(e);
        }
    }

    public static ByteBuffer allocBuffer(long size) {
        return MemoryUtils.allocBuffer(size, MemoryUtils.defaultByteOrder());
    }

    public static synchronized ByteBuffer allocBuffer(long size, ByteOrder order) {
        if (size < 0L) {
            throw new IllegalArgumentException("Size is negative or too large");
        }
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size " + size + " too large for ByteBuffer. Do smaller allocations or use unmanaged memory.");
        }
        if (!BEFORE_ALLOCATION_CALLBACK.isEmpty()) {
            BEFORE_ALLOCATION_CALLBACK.get().accept(size);
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect((int)size);
        buffer.order(order);
        if (MemoryUtils.useMemoryTracker()) {
            MemoryUtils.track(buffer, size, MemoryUtils.caller());
        }
        return buffer;
    }

    private static void track(ByteBuffer buffer, long size, StackTraceElement[] stackTrace) {
        NativeMemoryTrackerImpl nativeMemoryTracker = (NativeMemoryTrackerImpl)MemoryUtils.getMemoryTracker();
        AllocationInfo allocationInfo = new AllocationInfo(buffer, size, stackTrace);
        nativeMemoryTracker.track(allocationInfo);
        if (!ALLOCATION_CALLBACK.isEmpty()) {
            ALLOCATION_CALLBACK.get().accept(allocationInfo);
        }
    }

    private static StackTraceElement[] caller() {
        int start;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length <= 2) {
            return new StackTraceElement[0];
        }
        for (int i = start = 2; i < stackTrace.length; ++i) {
            if (stackTrace[i].getClassName().endsWith(MemoryUtils.class.getName())) continue;
            start = i;
            break;
        }
        return Arrays.copyOfRange(stackTrace, start, stackTrace.length);
    }

    public static long addressOf(Buffer buffer) {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Buffer is not direct");
        }
        return UNSAFE.getLong(buffer, BUFFER_ADDRESS_OFFSET);
    }

    public static long malloc(long bytes) {
        return UNSAFE.allocateMemory(bytes);
    }

    public static long calloc(long bytes) {
        long ptr = MemoryUtils.malloc(bytes);
        MemoryUtils.memset(ptr, bytes, 0);
        return ptr;
    }

    public static long realloc(long ptr, long bytes) {
        return UNSAFE.reallocateMemory(ptr, bytes);
    }

    public static void memset(long ptr, long bytes, int value) {
        UNSAFE.setMemory(ptr, bytes, (byte)(value & 0xFF));
    }

    public static void memcpy(long src, long dest, long bytes) {
        UNSAFE.copyMemory(src, dest, bytes);
    }

    public static void memcpy(ByteBuffer src, long srcOffset, byte[] dest, long destOffset, long bytes) {
        MemoryUtils.memcpy(MemoryUtils.addressOf(src), srcOffset, dest, destOffset, bytes);
    }

    public static void memcpy(long srcAddress, long srcOffset, byte[] dest, long destOffset, long bytes) {
        UNSAFE.copyMemory(null, srcAddress + srcOffset, dest, MemoryUtils.arrayBaseOffset(dest.getClass()) + destOffset, bytes);
    }

    public static void memcpy(byte[] src, long srcOffset, ByteBuffer dest, long destOffset, long bytes) {
        MemoryUtils.memcpy(src, srcOffset, MemoryUtils.addressOf(dest), destOffset, bytes);
    }

    public static void memcpy(byte[] src, long srcOffset, long destAddress, long destOffset, long bytes) {
        UNSAFE.copyMemory(src, MemoryUtils.arrayBaseOffset(src.getClass()) + srcOffset, null, destAddress + destOffset, bytes);
    }

    public static void free(long ptr) {
        AllocationInfo allocationInfo;
        if (MemoryUtils.useMemoryTracker() && !FREE_CALLBACK.isEmpty() && (allocationInfo = MemoryUtils.getMemoryTracker().find(ptr)) != null) {
            FREE_CALLBACK.get().accept(allocationInfo);
        }
        UNSAFE.freeMemory(ptr);
    }

    public static void free(ByteBuffer buffer) {
        AllocationInfo allocationInfo;
        if (MemoryUtils.useMemoryTracker() && !FREE_CALLBACK.isEmpty() && (allocationInfo = MemoryUtils.getMemoryTracker().find(MemoryUtils.addressOf(buffer))) != null) {
            FREE_CALLBACK.get().accept(allocationInfo);
        }
        UNSAFE.invokeCleaner(buffer);
    }

    public static byte getByte(long ptr, long offset) {
        return UNSAFE.getByte(ptr + offset);
    }

    public static void setByte(long ptr, long offset, int value) {
        UNSAFE.putByte(ptr + offset, (byte)(value & 0xFF));
    }

    public static short getShort(long ptr, long offset) {
        return UNSAFE.getShort(ptr + offset);
    }

    public static void setShort(long ptr, long offset, int value) {
        UNSAFE.putShort(ptr + offset, (short)(value & 0xFFFF));
    }

    public static char getChar(long ptr, long offset) {
        return UNSAFE.getChar(ptr + offset);
    }

    public static void setChar(long ptr, long offset, char value) {
        UNSAFE.putChar(ptr + offset, value);
    }

    public static int getInt(long ptr, long offset) {
        return UNSAFE.getInt(ptr + offset);
    }

    public static void setInt(long ptr, long offset, int value) {
        UNSAFE.putInt(ptr + offset, value);
    }

    public static long getLong(long ptr, long offset) {
        return UNSAFE.getLong(ptr + offset);
    }

    public static void setLong(long ptr, long offset, long value) {
        UNSAFE.putLong(ptr + offset, value);
    }

    public static float getFloat(long ptr, long offset) {
        return UNSAFE.getFloat(ptr + offset);
    }

    public static void setFloat(long ptr, long offset, float value) {
        UNSAFE.putFloat(ptr + offset, value);
    }

    public static double getDouble(long ptr, long offset) {
        return UNSAFE.getDouble(ptr + offset);
    }

    public static void setDouble(long ptr, long offset, double value) {
        UNSAFE.putDouble(ptr + offset, value);
    }

    public static long arrayBaseOffset(Class<?> arrayClass) {
        return UNSAFE.arrayBaseOffset(arrayClass);
    }

    private MemoryUtils() {
    }

    static {
        Field field;
        DEFAULT_BYTE_ORDER = new Configuration();
        USE_MEMORY_TRACKER = new Configuration();
        BEFORE_ALLOCATION_CALLBACK = new Configuration();
        ALLOCATION_CALLBACK = new Configuration();
        FREE_CALLBACK = new Configuration();
        MEMORY_TRACKER = new Configuration();
        Unsafe unsafe = null;
        try {
            Field field2 = Unsafe.class.getDeclaredField("theUnsafe");
            field2.setAccessible(true);
            unsafe = (Unsafe)field2.get(null);
        }
        catch (Exception e) {
            Logger.error(e);
        }
        UNSAFE = unsafe;
        DIRECT_BUFFER_CLASS = ByteBuffer.allocateDirect(0).getClass();
        long offset = 0L;
        try {
            field = Buffer.class.getDeclaredField("address");
            offset = UNSAFE.objectFieldOffset(field);
        }
        catch (Exception e) {
            Logger.error(e);
        }
        BUFFER_ADDRESS_OFFSET = offset;
        offset = 0L;
        try {
            field = Buffer.class.getDeclaredField("mark");
            offset = UNSAFE.objectFieldOffset(field);
        }
        catch (Exception e) {
            Logger.error(e);
        }
        BUFFER_MARK_OFFSET = offset;
        offset = 0L;
        try {
            field = Buffer.class.getDeclaredField("position");
            offset = UNSAFE.objectFieldOffset(field);
        }
        catch (Exception e) {
            Logger.error(e);
        }
        BUFFER_POSITION_OFFSET = offset;
        offset = 0L;
        try {
            field = Buffer.class.getDeclaredField("capacity");
            offset = UNSAFE.objectFieldOffset(field);
        }
        catch (Exception e) {
            Logger.error(e);
        }
        BUFFER_CAPACITY_OFFSET = offset;
        offset = 0L;
        try {
            field = Buffer.class.getDeclaredField("limit");
            offset = UNSAFE.objectFieldOffset(field);
        }
        catch (Exception e) {
            Logger.error(e);
        }
        BUFFER_LIMIT_OFFSET = offset;
    }
}

