/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.util.iterators;

import io.intino.alexandria.led.util.iterators.SimpleStatefulIterator;
import io.intino.alexandria.led.util.iterators.StatefulIterator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MergedIterator<T>
implements StatefulIterator<T> {
    private final List<StatefulIterator<T>> iterators;
    private final Comparator<StatefulIterator<T>> comparator;
    private T current = null;

    public MergedIterator(Stream<? extends Iterator<T>> iterators, Comparator<T> comparator) {
        this.iterators = iterators.map(SimpleStatefulIterator::new).collect(Collectors.toList());
        this.comparator = (o1, o2) -> comparator.compare(o1.current(), o2.current());
        this.prepareIterators();
    }

    private void prepareIterators() {
        this.iterators.removeIf(i -> !i.hasNext() || i.next() == null);
        this.iterators.sort(this.comparator);
    }

    @Override
    public T current() {
        return this.current;
    }

    @Override
    public boolean hasNext() {
        return !this.iterators.isEmpty();
    }

    @Override
    public T next() {
        StatefulIterator<T> iterator = this.iterators.remove(0);
        this.current = iterator.current();
        this.updateIterators(iterator);
        return this.current;
    }

    private void updateIterators(StatefulIterator<T> iterator) {
        iterator.next();
        if (iterator.current() == null) {
            return;
        }
        int index = Collections.binarySearch(this.iterators, iterator, this.comparator);
        index = index < 0 ? (index + 1) * -1 : index;
        this.iterators.add(index, iterator);
    }
}

