/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.leds;

import io.intino.alexandria.led.Led;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.indexed.ListAllocator;

public class DynamicLed<T extends Transaction>
implements Led<T> {
    private final ListAllocator<T> allocator;
    private final int transactionSize;

    public DynamicLed(int schemaSize, TransactionFactory<T> factory) {
        this.transactionSize = schemaSize;
        this.allocator = new ListAllocator<T>(1000L, schemaSize, factory);
    }

    public Transaction newTransaction() {
        return this.allocator.malloc();
    }

    @Override
    public long size() {
        return this.allocator.size();
    }

    @Override
    public int transactionSize() {
        return this.transactionSize;
    }

    @Override
    public T transaction(int index) {
        if ((long)index >= this.size()) {
            throw new IndexOutOfBoundsException("Index >= " + this.size());
        }
        return this.allocator.malloc(index);
    }
}

