/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.allocators.stack;

import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.stack.StackAllocator;
import io.intino.alexandria.led.buffers.store.ByteStore;
import io.intino.alexandria.led.exceptions.StackAllocatorOverflowException;
import io.intino.alexandria.led.exceptions.StackAllocatorUnderflowException;
import io.intino.alexandria.led.util.memory.MemoryUtils;
import io.intino.alexandria.led.util.memory.ModifiableMemoryAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;

public class SingleStackAllocator<T extends Transaction>
implements StackAllocator<T> {
    private final int elementSize;
    private ByteStore stack;
    private final ModifiableMemoryAddress address;
    private final AtomicLong stackPointer;
    private final TransactionFactory<T> factory;

    public SingleStackAllocator(ByteStore store, ModifiableMemoryAddress address, int elementSize, TransactionFactory<T> factory) {
        this.elementSize = elementSize;
        this.stack = store;
        this.factory = factory;
        this.stackPointer = new AtomicLong();
        this.address = address;
    }

    @Override
    public long address() {
        return this.address.get();
    }

    @Override
    public long stackSize() {
        return this.stack.byteSize();
    }

    @Override
    public long stackPointer() {
        return this.stackPointer.get();
    }

    @Override
    public long remainingBytes() {
        return this.stackSize() - this.stackPointer.get();
    }

    @Override
    public long size() {
        return this.stackSize() / (long)this.elementSize;
    }

    @Override
    public synchronized T malloc() {
        if (this.remainingBytes() < (long)this.elementSize) {
            throw new StackAllocatorOverflowException();
        }
        ByteStore store = this.stack.slice(this.stackPointer.getAndAdd(this.elementSize), this.elementSize);
        return (T)((Transaction)this.factory.newInstance(store));
    }

    @Override
    public synchronized T calloc() {
        T instance = this.malloc();
        ((Transaction)instance).clear();
        return instance;
    }

    @Override
    public int transactionSize() {
        return this.elementSize;
    }

    @Override
    public synchronized void pop() {
        if (this.stackPointer.get() == 0L) {
            throw new StackAllocatorUnderflowException();
        }
        this.stackPointer.addAndGet(-this.elementSize);
    }

    @Override
    public synchronized void clear() {
        this.stackPointer.set(0L);
    }

    @Override
    public synchronized void free() {
        if (this.address.notNull()) {
            Object storeImpl = this.stack.storeImpl();
            if (storeImpl instanceof ByteBuffer) {
                MemoryUtils.free((ByteBuffer)storeImpl);
            } else if (storeImpl instanceof Long) {
                MemoryUtils.free((Long)storeImpl);
            }
            this.address.set(0L);
            this.stack = null;
        }
    }
}

