/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.allocators.indexed;

import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.indexed.ArrayAllocator;
import io.intino.alexandria.led.allocators.indexed.IndexedAllocator;
import io.intino.alexandria.led.allocators.indexed.ManagedIndexedAllocator;
import io.intino.alexandria.led.util.memory.MemoryUtils;
import io.intino.alexandria.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public interface IndexedAllocatorFactory<T extends Transaction> {
    public static <S extends Transaction> ManagedIndexedAllocator<S> newManagedIndexedAllocator(InputStream inputStream, long elementCount, int elementSize, TransactionFactory<S> factory) {
        try {
            int bytesRead;
            if (elementCount < 0L) {
                throw new IllegalArgumentException("Element count cannot be < 0");
            }
            if (elementCount * (long)elementSize >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Buffer size too large for ManagedIndexedAllocator");
            }
            ByteBuffer buffer = MemoryUtils.allocBuffer(elementCount * (long)elementSize);
            byte[] inputBuffer = new byte[1024];
            while ((bytesRead = inputStream.read(inputBuffer)) > 0) {
                buffer.put(inputBuffer, 0, bytesRead);
            }
            buffer.clear();
            return new ManagedIndexedAllocator<S>(buffer, 0, buffer.capacity(), elementSize, factory);
        }
        catch (IOException e) {
            Logger.error(e);
            return null;
        }
    }

    public static <S extends Transaction> IndexedAllocator<S> newArrayAllocator(InputStream inputStream, long elementCount, int elementSize, TransactionFactory<S> factory) {
        try {
            int bytesRead;
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
            byte[] inputBuffer = new byte[1024 * elementSize];
            while ((bytesRead = inputStream.read(inputBuffer)) > 0) {
                ByteBuffer buffer = MemoryUtils.allocBuffer(bytesRead);
                MemoryUtils.memcpy(inputBuffer, 0L, buffer, 0L, (long)bytesRead);
                buffers.add(buffer);
            }
            return new ArrayAllocator<S>(buffers, elementSize, factory);
        }
        catch (IOException e) {
            Logger.error(e);
            return null;
        }
    }

    public IndexedAllocator<T> create(InputStream var1, long var2, int var4, TransactionFactory<T> var5) throws IOException;
}

