/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.allocators.indexed;

import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.indexed.IndexedAllocator;
import io.intino.alexandria.led.buffers.store.ByteBufferStore;
import io.intino.alexandria.led.buffers.store.ByteStore;
import io.intino.alexandria.led.util.OffHeapObject;
import io.intino.alexandria.led.util.memory.MemoryUtils;
import io.intino.alexandria.led.util.memory.ModifiableMemoryAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ArrayAllocator<T extends Transaction>
implements IndexedAllocator<T> {
    private ByteBufferStore[] stores;
    private final ModifiableMemoryAddress[] addresses;
    private final Map<Integer, Integer> indices;
    private final int elementSize;
    private final TransactionFactory<T> factory;

    public ArrayAllocator(int capacity, int elementsPerBuffer, int elementSize, TransactionFactory<T> factory) {
        this(ArrayAllocator.generateBuffers(capacity, elementsPerBuffer * elementSize), elementSize, factory);
    }

    public ArrayAllocator(List<ByteBuffer> buffers, int elementSize, TransactionFactory<T> factory) {
        this.elementSize = elementSize;
        this.factory = factory;
        this.addresses = new ModifiableMemoryAddress[buffers.size()];
        this.stores = new ByteBufferStore[buffers.size()];
        this.indices = new HashMap<Integer, Integer>(buffers.size());
        int offset = 0;
        for (int i = 0; i < buffers.size(); ++i) {
            ByteBuffer buffer = buffers.get(i);
            ModifiableMemoryAddress address = ModifiableMemoryAddress.of(buffer);
            ByteBufferStore store = new ByteBufferStore(buffer, address, buffer.position(), buffer.limit());
            this.addresses[i] = address;
            this.stores[i] = store;
            this.indices.put(i, offset);
            offset += this.countElements(store);
        }
    }

    @Override
    public T malloc(int index) {
        int storeIndex = this.storeIndex(index);
        ByteBufferStore store = this.stores[storeIndex];
        int relativeIndex = this.storeRelativeIndex(index, storeIndex);
        int offset = relativeIndex * this.elementSize;
        return (T)((Transaction)this.factory.newInstance(store.slice(offset, this.elementSize)));
    }

    @Override
    public T calloc(int index) {
        T instance = this.malloc(index);
        ((Transaction)instance).clear();
        return instance;
    }

    @Override
    public void clear(int index) {
        int storeIndex = this.storeIndex(index);
        int relativeIndex = this.storeRelativeIndex(index, storeIndex);
        MemoryUtils.memset(this.addresses[storeIndex].get() + (long)(relativeIndex * this.elementSize), this.elementSize, 0);
    }

    @Override
    public long byteSize() {
        return Arrays.stream(this.stores).mapToLong(OffHeapObject::byteSize).sum();
    }

    @Override
    public long size() {
        return Arrays.stream(this.stores).mapToInt(this::countElements).sum();
    }

    @Override
    public T malloc() {
        return this.malloc(0);
    }

    @Override
    public T calloc() {
        return this.calloc(0);
    }

    @Override
    public int transactionSize() {
        return this.elementSize;
    }

    @Override
    public void clear() {
    }

    @Override
    public void free() {
        if (this.stores != null) {
            for (int i = 0; i < this.stores.length; ++i) {
                ByteBufferStore store = this.stores[i];
                ModifiableMemoryAddress address = this.addresses[i];
                if (!address.notNull()) continue;
                MemoryUtils.free(store.storeImpl());
                address.set(0L);
            }
            this.stores = null;
        }
    }

    private int storeIndex(int elementIndex) {
        long end = 0L;
        for (int i = 0; i < this.stores.length; ++i) {
            ByteBufferStore store = this.stores[i];
            if ((long)elementIndex >= (end += store.byteSize() / (long)this.elementSize)) continue;
            return i;
        }
        throw new IndexOutOfBoundsException(elementIndex + " out of " + end);
    }

    private int storeRelativeIndex(int elementIndex, int storeIndex) {
        int offset = this.indices.get(storeIndex);
        return elementIndex - offset;
    }

    private int countElements(ByteStore store) {
        return (int)(store.byteSize() / (long)this.elementSize);
    }

    private static List<ByteBuffer> generateBuffers(int capacity, int bufferSize) {
        return IntStream.range(0, capacity).mapToObj(i -> MemoryUtils.allocBuffer(bufferSize)).collect(Collectors.toList());
    }
}

