/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led.allocators;

import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionAllocator;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.buffers.store.ByteBufferStore;
import io.intino.alexandria.led.util.memory.MemoryAddress;
import io.intino.alexandria.led.util.memory.MemoryUtils;
import java.nio.ByteBuffer;

public class DefaultAllocator<T extends Transaction>
implements TransactionAllocator<T> {
    private final int elementSize;
    private final TransactionFactory<T> factory;

    public DefaultAllocator(int transactionSize, TransactionFactory<T> factory) {
        this.elementSize = transactionSize;
        this.factory = factory;
    }

    @Override
    public long size() {
        return Long.MAX_VALUE;
    }

    @Override
    public T malloc() {
        ByteBuffer buffer = MemoryUtils.allocBuffer(this.elementSize);
        MemoryAddress address = MemoryAddress.of(buffer);
        ByteBufferStore store = new ByteBufferStore(buffer, address, 0, this.elementSize);
        return (T)((Transaction)this.factory.newInstance(store));
    }

    @Override
    public T calloc() {
        T instance = this.malloc();
        ((Transaction)instance).clear();
        return instance;
    }

    @Override
    public int transactionSize() {
        return this.elementSize;
    }

    @Override
    public void clear() {
    }

    @Override
    public void free() {
    }
}

