/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led;

import io.intino.alexandria.led.HeapLedStreamBuilder;
import io.intino.alexandria.led.Led;
import io.intino.alexandria.led.LedWriter;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionAllocator;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.stack.StackAllocators;
import io.intino.alexandria.led.allocators.stack.StackListAllocator;
import io.intino.alexandria.led.leds.IteratorLedStream;
import io.intino.alexandria.led.util.iterators.IteratorUtils;
import io.intino.alexandria.led.util.iterators.MergedIterator;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface LedStream<T extends Transaction>
extends Iterator<T>,
AutoCloseable {
    public static <T extends Transaction> LedStream<T> empty() {
        return IteratorLedStream.fromStream(0, Stream.empty());
    }

    public static <T extends Transaction> LedStream<T> fromLed(Led<T> led) {
        return led.toLedStream();
    }

    public static <T extends Transaction> LedStream<T> fromStream(int transactionSize, Stream<T> stream) {
        return IteratorLedStream.fromStream(transactionSize, stream);
    }

    public static <T extends Transaction> LedStream<T> of(int transactionSize, T ... transactions) {
        return LedStream.fromStream(transactionSize, Arrays.stream(transactions));
    }

    public static <T extends Transaction> LedStream<T> singleton(int transactionSize, T transaction) {
        return LedStream.fromStream(transactionSize, Stream.of(transaction));
    }

    public static <T extends Transaction> LedStream<T> merged(Stream<LedStream<T>> ledStreams) {
        return LedStream.merged(ledStreams.iterator());
    }

    public static <T extends Transaction> LedStream<T> merged(Iterator<LedStream<T>> iterator) {
        if (!iterator.hasNext()) {
            return LedStream.empty();
        }
        return iterator.next().merge(IteratorUtils.streamOf(iterator));
    }

    public static <T extends Transaction> Builder<T> builder(Class<T> transactionClass) {
        return new HeapLedStreamBuilder<T>(transactionClass);
    }

    public static <T extends Transaction> Builder<T> builder(Class<T> transactionClass, File tempDirectory) {
        return new HeapLedStreamBuilder<T>(transactionClass, tempDirectory);
    }

    public static <T extends Transaction> Builder<T> builder(Class<T> transactionClass, int numElementsPerBlock) {
        return new HeapLedStreamBuilder<T>(transactionClass, numElementsPerBlock);
    }

    public static <T extends Transaction> Builder<T> builder(Class<T> transactionClass, int numElementsPerBlock, File tempDirectory) {
        return new HeapLedStreamBuilder<T>(transactionClass, numElementsPerBlock, tempDirectory);
    }

    public static <T extends Transaction> Builder<T> builder(Class<T> transactionClass, TransactionFactory<T> factory) {
        return new HeapLedStreamBuilder<T>(transactionClass, factory);
    }

    public static <T extends Transaction> Builder<T> builder(Class<T> transactionClass, TransactionFactory<T> factory, File tempDirectory) {
        return new HeapLedStreamBuilder<T>(transactionClass, factory, tempDirectory);
    }

    public static <T extends Transaction> Builder<T> builder(Class<T> transactionClass, TransactionFactory<T> factory, int numElementsPerBlock) {
        return new HeapLedStreamBuilder<T>(transactionClass, factory, numElementsPerBlock);
    }

    public static <T extends Transaction> Builder<T> builder(Class<T> transactionClass, TransactionFactory<T> factory, int numElementsPerBlock, File tempDirectory) {
        return new HeapLedStreamBuilder<T>(transactionClass, factory, numElementsPerBlock, tempDirectory);
    }

    public int transactionSize();

    @Override
    public boolean hasNext();

    @Override
    public T next();

    default public Spliterator<T> spliterator() {
        return Spliterators.spliteratorUnknownSize(this, 4);
    }

    default public Stream<T> asJavaStream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public LedStream<T> filter(Predicate<T> condition) {
        return new Filter<T>(this, condition);
    }

    default public LedStream<T> peek(Consumer<T> consumer) {
        return new Peek<T>(this, consumer);
    }

    default public <R extends Transaction> LedStream<R> map(TransactionAllocator<R> allocator, BiConsumer<T, R> mapper) {
        return new Map<T, R>(this, allocator, mapper);
    }

    default public <R extends Transaction> LedStream<R> map(int rSize, TransactionFactory<R> factory, BiConsumer<T, R> mapper) {
        return new Map<T, R>(this, rSize, factory, mapper);
    }

    default public <R extends Transaction> LedStream<R> map(Class<R> newType, BiConsumer<T, R> mapper) {
        return new Map<T, R>(this, Transaction.sizeOf(newType), Transaction.factoryOf(newType), mapper);
    }

    default public <R> Stream<R> mapToObj(Function<T, R> mapper) {
        return this.asJavaStream().map(mapper);
    }

    default public LedStream<T> merge(LedStream<T> other) {
        return new Merge<T>(this, other);
    }

    default public LedStream<T> merge(Stream<LedStream<T>> others) {
        return new Merge<T>(this, others);
    }

    default public <O extends Transaction> LedStream<T> removeAll(LedStream<O> other) {
        return new RemoveAll(this, other);
    }

    default public LedStream<T> removeAll(Iterable<Long> other) {
        return new RemoveAll(this, other.iterator());
    }

    default public LedStream<T> removeAll(Iterator<Long> other) {
        return new RemoveAll(this, other);
    }

    default public <O extends Transaction> LedStream<T> retainAll(LedStream<O> other) {
        return new RetainAll(this, other);
    }

    default public LedStream<T> retainAll(Iterable<Long> other) {
        return new RetainAll(this, other.iterator());
    }

    default public LedStream<T> retainAll(Iterator<Long> other) {
        return new RetainAll(this, other);
    }

    default public Optional<T> findFirst() {
        return this.hasNext() ? Optional.ofNullable(this.next()) : Optional.empty();
    }

    default public Optional<T> findLast() {
        Object last = null;
        while (this.hasNext()) {
            last = this.next();
        }
        return Optional.ofNullable(last);
    }

    default public boolean allMatch(Predicate<T> condition) {
        while (this.hasNext()) {
            if (condition.test(this.next())) continue;
            return false;
        }
        return true;
    }

    default public boolean anyMatch(Predicate<T> condition) {
        while (this.hasNext()) {
            if (!condition.test(this.next())) continue;
            return true;
        }
        return false;
    }

    default public boolean noneMatch(Predicate<T> condition) {
        while (this.hasNext()) {
            if (!condition.test(this.next())) continue;
            return false;
        }
        return true;
    }

    default public void forEach(Consumer<T> consumer) {
        while (this.hasNext()) {
            consumer.accept(this.next());
        }
    }

    default public void serialize(File file) {
        LedWriter ledWriter = new LedWriter(file);
        ledWriter.write(this);
    }

    default public LedStream<T> onClose(Runnable onClose) {
        return this;
    }

    public static interface Builder<T extends Transaction> {
        public Class<T> transactionClass();

        public int transactionSize();

        public Builder<T> append(Consumer<T> var1);

        public LedStream<T> build();
    }

    public static class Map<T extends Transaction, R extends Transaction>
    extends LedStreamOperation<T, R> {
        private static final int DEFAULT_ELEMENTS_PER_STACK = 1024;
        private final TransactionAllocator<R> allocator;
        private final BiConsumer<T, R> mapper;

        public Map(LedStream<T> source, TransactionAllocator<R> allocator, BiConsumer<T, R> mapper) {
            super(source);
            this.allocator = Objects.requireNonNull(allocator);
            this.mapper = Objects.requireNonNull(mapper);
        }

        public Map(LedStream<T> source, int rSize, TransactionFactory<R> factory, BiConsumer<T, R> mapper) {
            this(source, Map.getDefaultAllocator(rSize, factory), mapper);
        }

        @Override
        public int transactionSize() {
            return this.allocator.transactionSize();
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public R next() {
            R newElement = this.allocator.calloc();
            this.mapper.accept(this.source.next(), newElement);
            return newElement;
        }

        private static <R extends Transaction> TransactionAllocator<R> getDefaultAllocator(int rSize, TransactionFactory<R> factory) {
            return new StackListAllocator<R>(1024, rSize, factory, StackAllocators::newManaged);
        }
    }

    public static class RetainAll<T extends Transaction>
    extends LedStreamOperation<T, T> {
        private final Iterator<Long> other;
        private T current;

        public RetainAll(LedStream<T> source, LedStream<?> other) {
            this(source, other.mapToObj(Transaction::idOf).iterator());
        }

        public RetainAll(LedStream<T> source, Iterator<Long> idIterator) {
            super(source);
            this.other = Objects.requireNonNull(idIterator);
        }

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                this.advanceToNextElement();
            }
            return this.current != null;
        }

        private void advanceToNextElement() {
            if (!this.source.hasNext() || !this.other.hasNext()) {
                return;
            }
            Object sourceElement = this.source.next();
            long otherElementId = this.other.next();
            while (Transaction.idOf((Transaction)sourceElement) < otherElementId) {
                if (!this.source.hasNext()) {
                    return;
                }
                sourceElement = this.source.next();
            }
            while (Transaction.idOf((Transaction)sourceElement) > otherElementId) {
                if (!this.other.hasNext()) {
                    return;
                }
                otherElementId = this.other.next();
            }
            if (Transaction.idOf((Transaction)sourceElement) == otherElementId) {
                this.current = sourceElement;
            }
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T next = this.current;
            this.current = null;
            return next;
        }
    }

    public static class Merge<T extends Transaction>
    extends LedStreamOperation<T, T> {
        private final MergedIterator<T> mergedIterator;

        public Merge(LedStream<T> source, LedStream<T> other) {
            super(source);
            this.mergedIterator = new MergedIterator<Transaction>(Stream.of(source, Objects.requireNonNull(other)), Comparator.comparingLong(Transaction::idOf));
        }

        public Merge(LedStream<T> source, Stream<LedStream<T>> others) {
            super(source);
            this.mergedIterator = new MergedIterator<Transaction>(Stream.concat(Stream.of(source), others), Comparator.comparingLong(Transaction::idOf));
        }

        @Override
        public boolean hasNext() {
            return this.mergedIterator.hasNext();
        }

        @Override
        public T next() {
            return (T)((Transaction)this.mergedIterator.next());
        }
    }

    public static class RemoveAll<T extends Transaction>
    extends LedStreamOperation<T, T> {
        private final Iterator<Long> other;
        private T sourceCurrent;
        private Long otherCurrentId;

        public RemoveAll(LedStream<T> source, LedStream<?> other) {
            this(source, other.mapToObj(Transaction::idOf).iterator());
        }

        public RemoveAll(LedStream<T> source, Iterator<Long> idIterator) {
            super(source);
            this.other = Objects.requireNonNull(idIterator);
        }

        @Override
        public boolean hasNext() {
            if (this.sourceCurrent == null) {
                this.advanceToNextElement();
            }
            return this.sourceCurrent != null;
        }

        private void advanceToNextElement() {
            if (!this.source.hasNext()) {
                return;
            }
            if (!this.other.hasNext()) {
                this.sourceCurrent = this.source.next();
                this.otherCurrentId = null;
                return;
            }
            Object sourceElement = this.source.next();
            if (this.otherCurrentId == null) {
                this.otherCurrentId = this.other.next();
            }
            if (Transaction.idOf((Transaction)sourceElement) < this.otherCurrentId) {
                this.sourceCurrent = sourceElement;
                return;
            }
            while (Transaction.idOf((Transaction)sourceElement) > this.otherCurrentId) {
                if (this.other.hasNext()) {
                    this.otherCurrentId = this.other.next();
                    continue;
                }
                this.sourceCurrent = sourceElement;
                this.otherCurrentId = null;
                return;
            }
            do {
                long id;
                int comparison;
                if ((comparison = Long.compare(id = Transaction.idOf((Transaction)sourceElement), this.otherCurrentId)) == 0) {
                    if (this.source.hasNext()) {
                        sourceElement = this.source.next();
                        continue;
                    }
                    this.sourceCurrent = null;
                    return;
                }
                if (comparison <= 0) continue;
                if (this.other.hasNext()) {
                    this.otherCurrentId = this.other.next();
                    continue;
                }
                this.otherCurrentId = null;
                break;
            } while (Transaction.idOf((Transaction)sourceElement) >= this.otherCurrentId);
            this.sourceCurrent = sourceElement;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T next = this.sourceCurrent;
            this.sourceCurrent = null;
            return next;
        }
    }

    public static class Peek<T extends Transaction>
    extends LedStreamOperation<T, T> {
        private final Consumer<T> consumer;

        public Peek(LedStream<T> source, Consumer<T> consumer) {
            super(source);
            this.consumer = Objects.requireNonNull(consumer);
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public T next() {
            Object next = this.source.next();
            this.consumer.accept(next);
            return (T)next;
        }
    }

    public static class Filter<T extends Transaction>
    extends LedStreamOperation<T, T> {
        private final Predicate<T> condition;
        private T current;

        public Filter(LedStream<T> source, Predicate<T> condition) {
            super(source);
            this.condition = Objects.requireNonNull(condition);
        }

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                this.advanceToNextElement();
            }
            return this.current != null;
        }

        private void advanceToNextElement() {
            while (this.source.hasNext()) {
                Object next = this.source.next();
                if (!this.condition.test(next)) continue;
                this.current = next;
                break;
            }
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T next = this.current;
            this.current = null;
            return next;
        }
    }

    public static abstract class LedStreamOperation<T extends Transaction, R extends Transaction>
    implements LedStream<R> {
        protected final LedStream<T> source;
        private Runnable onClose;
        private boolean closed;

        public LedStreamOperation(LedStream<T> source) {
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public int transactionSize() {
            return this.source.transactionSize();
        }

        @Override
        public LedStream<R> onClose(Runnable onClose) {
            this.onClose = onClose;
            return this;
        }

        @Override
        public void close() throws Exception {
            if (this.closed) {
                return;
            }
            if (this.onClose != null) {
                this.onClose.run();
            }
            this.source.close();
            this.closed = true;
        }
    }
}

