/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led;

import io.intino.alexandria.led.Led;
import io.intino.alexandria.led.LedHeader;
import io.intino.alexandria.led.LedStream;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.indexed.IndexedAllocator;
import io.intino.alexandria.led.allocators.indexed.IndexedAllocatorFactory;
import io.intino.alexandria.led.leds.IndexedLed;
import io.intino.alexandria.led.leds.InputLedStream;
import io.intino.alexandria.logger.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.xerial.snappy.SnappyInputStream;

public class LedReader {
    private final InputStream source;
    private final File sourceFile;

    public LedReader(File file) {
        this.source = LedReader.inputStreamOf(file);
        this.sourceFile = file;
    }

    public LedReader(InputStream source) {
        this.source = source;
        this.sourceFile = null;
    }

    public int size() {
        int n;
        if (this.sourceFile == null) {
            return -1;
        }
        RandomAccessFile raFile = new RandomAccessFile(this.sourceFile, "r");
        try {
            n = (int)raFile.readLong();
        }
        catch (Throwable throwable) {
            try {
                try {
                    raFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Logger.error(e);
                return -1;
            }
        }
        raFile.close();
        return n;
    }

    public <T extends Transaction> Led<T> readAll(TransactionFactory<T> factory) {
        return this.readAll(this.getDefaultAllocatorFactory(), factory);
    }

    public <T extends Transaction> Led<T> readAll(IndexedAllocatorFactory<T> allocatorFactory, TransactionFactory<T> factory) {
        IndexedLed<T> indexedLed;
        try {
            if (this.source.available() == 0) {
                return Led.empty();
            }
        }
        catch (Exception e) {
            Logger.error(e);
            return Led.empty();
        }
        LedHeader header = LedHeader.from(this.source);
        SnappyInputStream inputStream = new SnappyInputStream(this.source);
        try {
            IndexedAllocator<T> allocator = allocatorFactory.create(inputStream, header.elementCount(), header.elementSize(), factory);
            indexedLed = new IndexedLed<T>(allocator);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Logger.error(e);
                return Led.empty();
            }
        }
        inputStream.close();
        return indexedLed;
    }

    public <T extends Transaction> LedStream<T> read(TransactionFactory<T> factory) {
        try {
            if (this.source.available() == 0) {
                return LedStream.empty();
            }
            LedHeader header = LedHeader.from(this.source);
            return this.allocate(new SnappyInputStream(this.source), factory, header.elementSize());
        }
        catch (IOException e) {
            Logger.error(e);
            return LedStream.empty();
        }
    }

    public <T extends Transaction> LedStream<T> readUncompressed(int elementSize, TransactionFactory<T> factory) {
        try {
            if (this.source.available() == 0) {
                return LedStream.empty();
            }
            return this.allocate(this.source, factory, elementSize);
        }
        catch (IOException e) {
            Logger.error(e);
            return LedStream.empty();
        }
    }

    private <T extends Transaction> LedStream<T> allocate(InputStream inputStream, TransactionFactory<T> factory, int transactionSize) {
        return new InputLedStream<T>(inputStream, factory, transactionSize);
    }

    private static InputStream inputStreamOf(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            Logger.error("Failed to create FileInputStream for file " + file + ". Probably too many files has been opened.", e);
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private <T extends Transaction> IndexedAllocatorFactory<T> getDefaultAllocatorFactory() {
        return (inputStream, elementCount, elementSize, factory) -> {
            if (elementCount >= 0L && elementCount * (long)elementSize < Integer.MAX_VALUE) {
                return IndexedAllocatorFactory.newManagedIndexedAllocator(inputStream, elementCount, elementSize, factory);
            }
            return IndexedAllocatorFactory.newArrayAllocator(inputStream, elementCount, elementSize, factory);
        };
    }
}

