/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led;

import io.intino.alexandria.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Objects;

public class LedHeader {
    public static final int SIZE = 12;
    public static final long UNKNOWN_SIZE = -1L;
    private final ByteBuffer data;

    public static LedHeader from(InputStream inputStream) {
        try {
            byte[] buffer = new byte[12];
            inputStream.read(buffer);
            return new LedHeader(ByteBuffer.wrap(buffer));
        }
        catch (IOException e) {
            Logger.error(e);
            return null;
        }
    }

    public LedHeader() {
        this.data = ByteBuffer.allocate(12);
        this.elementCount(-1L);
    }

    public LedHeader(ByteBuffer data) {
        this.data = Objects.requireNonNull(data);
        if (data.capacity() < 12) {
            throw new IllegalArgumentException("Header must be 12 size in bytes");
        }
    }

    public static LedHeader from(FileChannel fileChannel) {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(12);
            fileChannel.read(buffer);
            return new LedHeader(buffer.clear());
        }
        catch (Exception e) {
            Logger.error(e);
            return null;
        }
    }

    public long elementCount() {
        return this.data.getLong(0);
    }

    public LedHeader elementCount(long elementCount) {
        this.data.putLong(0, elementCount);
        return this;
    }

    public int elementSize() {
        return this.data.getInt(8);
    }

    public LedHeader elementSize(int elementSize) {
        this.data.putInt(8, elementSize);
        return this;
    }

    public ByteBuffer data() {
        return this.data;
    }

    public byte[] toByteArray() {
        return this.data.array();
    }
}

