/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.led;

import io.intino.alexandria.led.Led;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.allocators.TransactionFactory;
import io.intino.alexandria.led.allocators.indexed.IndexedAllocator;
import io.intino.alexandria.led.allocators.indexed.ListAllocator;
import io.intino.alexandria.led.leds.ListLed;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class LedBuilder<T extends Transaction>
implements Led.Builder<T> {
    public static final int DEFAULT_INITIAL_CAPACITY = 1024;
    public static final float GROW_FACTOR = 1.5f;
    private final Class<T> transactionClass;
    private final IndexedAllocator<T> allocator;
    private T[] sortedTransactions;
    private int size;

    public LedBuilder(Class<T> transactionClass) {
        this(transactionClass, Transaction.factoryOf(transactionClass));
    }

    public LedBuilder(Class<T> transactionClass, TransactionFactory<T> factory) {
        this(transactionClass, LedBuilder.createBuilderDefaultAllocator(Transaction.sizeOf(transactionClass), factory));
    }

    public LedBuilder(Class<T> transactionClass, IndexedAllocator<T> allocator) {
        this.transactionClass = Objects.requireNonNull(transactionClass);
        this.allocator = Objects.requireNonNull(allocator);
        this.sortedTransactions = new Transaction[1024];
    }

    @Override
    public Class<T> transactionClass() {
        return this.transactionClass;
    }

    @Override
    public int transactionSize() {
        return this.allocator.transactionSize();
    }

    @Override
    public Led.Builder<T> create(Consumer<T> initializer) {
        Object transaction = this.allocator.malloc();
        initializer.accept(transaction);
        this.putInSortedList(transaction);
        return this;
    }

    private void putInSortedList(T transaction) {
        if (this.size == this.sortedTransactions.length) {
            this.grow();
        } else if (this.size == 0) {
            this.sortedTransactions[0] = transaction;
        } else {
            int index = Arrays.binarySearch(this.sortedTransactions, 0, this.size, transaction);
            if (index < 0) {
                index = -index + 1;
            }
            System.arraycopy(this.sortedTransactions, index, this.sortedTransactions, index + 1, ++this.size - index);
            this.sortedTransactions[index] = transaction;
        }
    }

    private void grow() {
        this.sortedTransactions = (Transaction[])Arrays.copyOf(this.sortedTransactions, Math.round((float)this.size * 1.5f));
    }

    @Override
    public Led<T> build() {
        return new ListLed<T>(this.getList());
    }

    private List<T> getList() {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index >= LedBuilder.this.size) {
                    throw new IndexOutOfBoundsException(index + " >= " + LedBuilder.this.size);
                }
                return LedBuilder.this.sortedTransactions[index];
            }

            @Override
            public int size() {
                return LedBuilder.this.size;
            }
        };
    }

    private static <T extends Transaction> IndexedAllocator<T> createBuilderDefaultAllocator(int transactionSize, TransactionFactory<T> factory) {
        return new ListAllocator<T>(1024L, transactionSize, factory);
    }
}

