/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ingestion;

import io.intino.alexandria.Fingerprint;
import io.intino.alexandria.Session;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.ingestion.SessionHandler;
import io.intino.alexandria.led.LedStream;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.UnsortedLedStreamBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class TransactionSession {
    private final SessionHandler.Provider provider;
    private final Map<Fingerprint, UnsortedLedStreamBuilder<? extends Transaction>> builders;
    private final int transactionsBufferSize;

    public TransactionSession(SessionHandler.Provider provider) {
        this(provider, 1000000);
    }

    public TransactionSession(SessionHandler.Provider provider, int transactionsBufferSize) {
        this.provider = provider;
        this.transactionsBufferSize = transactionsBufferSize;
        this.builders = new HashMap<Fingerprint, UnsortedLedStreamBuilder<? extends Transaction>>();
    }

    public <T extends Transaction> void put(String tank, Timetag timetag, Class<T> transactionClass, Stream<Consumer<T>> stream) {
        LedStream.Builder<T> builder = this.builder(Fingerprint.of(tank, timetag), transactionClass);
        stream.forEach(builder::append);
    }

    public <T extends Transaction> void put(String tank, Timetag timetag, Class<T> transactionClass, Consumer<T> transaction) {
        LedStream.Builder<T> builder = this.builder(Fingerprint.of(tank, timetag), transactionClass);
        builder.append(transaction);
    }

    private <T extends Transaction> LedStream.Builder<T> builder(Fingerprint fingerprint, Class<T> transactionClass) {
        if (!this.builders.containsKey(fingerprint)) {
            this.builders.put(fingerprint, new UnsortedLedStreamBuilder<T>(transactionClass, Transaction.factoryOf(transactionClass), this.transactionsBufferSize, this.provider.file(fingerprint.name(), Session.Type.led)));
        }
        return this.builders.get(fingerprint);
    }

    public void close() {
        this.builders.forEach((f, b) -> b.close());
    }
}

