/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.framework;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;

public interface PersistenceManager {
    public void delete(String var1);

    public InputStream read(String var1);

    public OutputStream write(String var1);

    public static class InMemoryPersistenceManager
    implements PersistenceManager {
        private final Map<String, ByteArrayOutputStream> content = new HashMap<String, ByteArrayOutputStream>();

        @Override
        public void delete(String path) {
            this.content.remove(path);
        }

        @Override
        public InputStream read(String path) {
            return new ByteArrayInputStream(this.content.getOrDefault(path, new ByteArrayOutputStream()).toByteArray());
        }

        @Override
        public OutputStream write(String path) {
            this.content.put(path, new ByteArrayOutputStream());
            return this.content.get(path);
        }
    }

    public static class FilePersistenceManager
    implements PersistenceManager {
        private final File directory;

        public FilePersistenceManager(File directory) {
            this.directory = directory;
        }

        @Override
        public void delete(String path) {
            new File(this.directory, path).delete();
        }

        @Override
        public InputStream read(String path) {
            try {
                if (!new File(this.directory, path).exists()) {
                    return new ByteArrayInputStream(new byte[0]);
                }
                return Files.newInputStream(new File(this.directory, path).toPath(), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public OutputStream write(String path) {
            try {
                File file = new File(this.directory, path);
                file.getParentFile().mkdirs();
                return new FileOutputStream(file);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

