/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.terminal.Connector;
import io.intino.cesar.datahub.events.consul.server.ServerStatus;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.StatusAction;

public class StatusRequest
implements Connector.MessageConsumer {
    private final ConsulBox box;

    public StatusRequest(ConsulBox box) {
        this.box = box;
    }

    @Override
    public void accept(String message, String callback) {
        try {
            ServerStatus status = this.actionFor().execute();
            this.box.datahubConnector().sendMessage(callback, status.toString());
            this.feed(status);
        }
        catch (Throwable e) {
            Logger.error(e);
        }
    }

    private void feed(ServerStatus status) {
        this.box.terminal().publish(status);
    }

    private StatusAction actionFor() {
        StatusAction action = new StatusAction();
        action.box = this.box;
        return action;
    }
}

