/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageReader;
import io.intino.alexandria.terminal.Connector;
import io.intino.cesar.datahub.events.Deploy;
import io.intino.cesar.datahub.events.DeployResult;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.DeployAction;

public class DeployRequest
implements Connector.MessageConsumer {
    private final ConsulBox box;

    public DeployRequest(ConsulBox box) {
        this.box = box;
    }

    @Override
    public void accept(String request, String callback) {
        try {
            if (!this.box.isProcessLaunchedOnStart()) {
                this.box.datahubConnector().sendMessage(callback, new DeployResult().success(false).remarks("Deploy not processed. Consul starting...").toMessage().toString());
            } else {
                this.box.datahubConnector().sendMessage(callback, this.actionFor(new Deploy(new MessageReader(request).next())).execute().toMessage().toString());
            }
        }
        catch (Throwable e) {
            Logger.error(e);
        }
    }

    private DeployAction actionFor(Deploy process) {
        DeployAction action = new DeployAction();
        action.box = this.box;
        action.deploy = process;
        return action;
    }
}

