/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageReader;
import io.intino.alexandria.terminal.Connector;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.DebugProcessAction;

public class DebugProcessRequest
implements Connector.MessageConsumer {
    private final ConsulBox box;

    public DebugProcessRequest(ConsulBox box) {
        this.box = box;
    }

    @Override
    public void accept(String request, String callback) {
        try {
            this.box.datahubConnector().sendMessage(callback, this.actionFor(this.processId(request), this.port(request)).execute().toString());
        }
        catch (Throwable e) {
            Logger.error(e);
        }
    }

    private Integer port(String request) {
        return new MessageReader(request).next().get("port").asInteger();
    }

    private String processId(String request) {
        return new MessageReader(request).next().get("processId").asString();
    }

    private DebugProcessAction actionFor(String processId, Integer port) {
        DebugProcessAction action = new DebugProcessAction();
        action.box = this.box;
        action.processId = processId;
        action.port = port;
        return action;
    }
}

