/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.process;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SyncHandler {
    private final File appsWorkspace;
    private final String deployUser;
    private final List<Process> rsyncProcesses = new ArrayList<Process>();

    public SyncHandler(File appsWorkspace, String deployUser) {
        this.appsWorkspace = appsWorkspace;
        this.deployUser = deployUser;
    }

    public void sync(String directory, List<String> targetServers) {
        for (String targetServer : targetServers) {
            try {
                this.rsyncProcesses.add(new ProcessBuilder("sudo", "-u", this.deployUser, "bash", "/opt/scripts/rsync-continuous", this.appsWorkspace.getAbsolutePath() + File.separator + directory, targetServer).directory(this.appsWorkspace).inheritIO().start());
            }
            catch (IOException e) {
                Logger.error(e);
            }
        }
    }

    void stop() {
        this.rsyncProcesses.forEach(Process::destroy);
    }
}

