/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.oshi;

import io.intino.consul.box.oshi.DiskStoreForPath;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.NetworkIF;
import oshi.software.os.OSFileStore;
import oshi.software.os.OSProcess;

public class OshiServerManager {
    private final SystemInfo si = new SystemInfo();

    public OshiServerManager() {
        LogManager.getCurrentLoggers().asIterator().forEachRemaining(c -> ((Logger)c).setLevel(Level.ERROR));
    }

    public double usedCPUUsagePercent() {
        CentralProcessor cpu = this.si.getHardware().getProcessor();
        return cpu.getSystemLoadAverage(3)[2];
    }

    public double usedMemoryPercent() {
        GlobalMemory memory = this.si.getHardware().getMemory();
        long used = memory.getTotal() - memory.getAvailable();
        return OshiServerManager.asPercent((float)used * 100.0f / (float)memory.getTotal());
    }

    public long memoryCapacityInMb() {
        return this.si.getHardware().getMemory().getTotal() / 0x100000L;
    }

    public long hddCapacityInMb(String path) {
        OSFileStore osFileStore = new DiskStoreForPath().get(path);
        return osFileStore == null ? 0L : osFileStore.getTotalSpace() / 0x100000L;
    }

    public long directoryTotalSize(String directory) {
        try {
            String line;
            if (!new File(directory).exists()) {
                return 0L;
            }
            Process p = Runtime.getRuntime().exec("du -s " + directory);
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
            }
            String text = builder.toString();
            return (long)(Double.parseDouble(text.substring(0, text.indexOf("\t"))) / 1048576.0);
        }
        catch (IOException | InterruptedException | NumberFormatException e) {
            return 0L;
        }
    }

    public int cores() {
        return this.si.getHardware().getProcessor().getLogicalProcessorCount();
    }

    public double usedHDDPercent(String path) {
        OSFileStore store = new DiskStoreForPath().get(path);
        if (store == null) {
            return -1.0;
        }
        return OshiServerManager.asPercent(100.0 - (double)store.getFreeSpace() / (double)store.getTotalSpace() * 100.0);
    }

    public long megabytesReceived() {
        NetworkIF networkIF = this.si.getHardware().getNetworkIFs().stream().filter(i -> i.getIPv4addr().length > 0).findFirst().orElse(null);
        return networkIF != null ? networkIF.getBytesRecv() / 0x100000L : 0L;
    }

    public long megabytesSent() {
        NetworkIF networkIF = this.si.getHardware().getNetworkIFs().stream().filter(i -> i.getIPv4addr().length > 0).findFirst().orElse(null);
        return networkIF != null ? networkIF.getBytesSent() / 0x100000L : 0L;
    }

    private static double asPercent(double number) {
        return Math.floor(number * 100.0) / 100.0;
    }

    public int openFiles(int pid) {
        try {
            OSProcess process = this.si.getOperatingSystem().getProcess(pid);
            if (process == null) {
                return 0;
            }
            return (int)process.getOpenFiles();
        }
        catch (Throwable e) {
            return 0;
        }
    }
}

