/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.cesar.datahub.events.consul.process.ProcessStatus;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ProcessFinder;
import io.intino.consul.box.oshi.OshiServerManager;
import io.intino.consul.box.process.ProcessConnector;
import io.intino.consul.box.process.ProcessManager;
import io.intino.consul.graph.Process;
import java.time.Instant;

public class ProcessStatusAction {
    public String processId;
    public ConsulBox box;

    public ProcessStatusAction(ConsulBox box, String processId) {
        this.box = box;
        this.processId = processId;
    }

    public ProcessStatusAction() {
    }

    public ProcessStatus execute() {
        Process process = ProcessFinder.processFromIdentifier(this.box.graph(), this.processId);
        if (process == null || !process.deployed()) {
            return new ProcessStatus().running(false).id(this.processId);
        }
        ProcessManager manager = this.box.processManager();
        boolean running = manager.isRunning(process);
        Logger.info("Status of " + this.processId + " sent");
        return running ? this.runningStatus(process) : this.defaultStatus(process).running(false).exitValue(manager.exitValue(process));
    }

    private ProcessStatus runningStatus(Process process) {
        try {
            ProcessConnector connector = new ProcessConnector(process).connect();
            ProcessStatus status = connector.status();
            if (status == null) {
                return this.defaultStatus(process).running(true);
            }
            status.id(this.processId).exitValue(-1000).serverId(this.box.serverId());
            if (status.threads() > 500) {
                connector.saveThreadDump(this.box.logsDirectory());
            }
            connector.disconnect();
            return status;
        }
        catch (Throwable e) {
            return this.defaultStatus(process).running(true);
        }
    }

    private ProcessStatus defaultStatus(Process process) {
        OshiServerManager manager = new OshiServerManager();
        return new ProcessStatus().ts(Instant.now()).id(this.processId).serverId(this.box.serverId()).workspaceSize(Double.valueOf(manager.directoryTotalSize(process.workspace()))).workspaceTotalSize(Double.valueOf(manager.directoryTotalSize(process.workspace()))).openFiles(manager.openFiles(process.pid()));
    }
}

