/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.cesar.datahub.events.Deploy;
import io.intino.cesar.datahub.events.DeployResult;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ProcessFinder;
import io.intino.consul.graph.Process;
import io.intino.magritte.framework.Layer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class DeployAction {
    private static final Object monitor = new Object();
    public Deploy deploy;
    public ConsulBox box;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DeployResult execute() {
        try {
            Object object = monitor;
            synchronized (object) {
                DeployResult result;
                Logger.info("Deploying " + this.deploy.artifact() + "...");
                Process oldProcess = ProcessFinder.processFromIdentifier(this.box.graph(), this.deploy.id());
                Process newProcess = this.createProcess();
                if (oldProcess != null) {
                    this.box.processManager().stop(oldProcess);
                }
                if ((result = this.box.processManager().deploy(newProcess)).success().booleanValue()) {
                    newProcess.save$();
                    if (oldProcess != null) {
                        oldProcess.delete$();
                    }
                } else {
                    newProcess.delete$();
                }
                return result;
            }
        }
        catch (Exception e) {
            Logger.error(e);
            return new DeployResult().success(false).remarks(e.getMessage());
        }
    }

    private Process createProcess() {
        File workspace = new File(this.box.applicationsWorkspace(), this.deploy.id().replace(":", "_"));
        Process process = this.box.graph().create(this.stashName()).process(this.deploy.id(), workspace.getAbsolutePath(), this.newJMXPort());
        String[] id = this.deploy.artifact().split(":");
        Process.Artifact artifact = process.create().artifact(id[0], id[1], id[2]);
        if (this.deploy.classpathPrefix() != null) {
            process.artifact().classpathPrefix(this.deploy.classpathPrefix());
        }
        process.create().requirements();
        if (this.deploy.requirements() != null) {
            if (this.deploy.requirements().minMemory() != null) {
                process.requirements().minMemory(this.deploy.requirements().minMemory());
            }
            if (this.deploy.requirements().maxMemory() != null) {
                process.requirements().maxMemory(this.deploy.requirements().maxMemory());
            }
            for (Deploy.Requirements.SyncFileToServer sync : this.deploy.requirements().syncFileToServerList()) {
                process.create().syncFileToServer(sync.directory(), sync.targetServers());
            }
        }
        this.addArtifactories(artifact);
        this.addParameters(process);
        process.save$();
        return process;
    }

    private int newJMXPort() {
        List usedPorts = this.box.graph().processList().stream().map(Process::managementPort).collect(Collectors.toList());
        return IntStream.range(10001, 11000).filter(p -> !usedPorts.contains(p)).findFirst().orElse(11000);
    }

    private String stashName() {
        return "processes/" + this.deploy.id().replace(":", "_").replace(".", "_");
    }

    private void addArtifactories(Process.Artifact artifact) {
        this.deploy.artifactoryList().forEach(artifactory -> artifact.create().artifactory(artifactory.url(), artifactory.id(), artifactory.user(), artifactory.password()));
    }

    private void addParameters(Process process) {
        new ArrayList<Process.Parameter>(process.parameterList()).forEach(Layer::delete$);
        this.deploy.parameterList().forEach(parameter -> process.create().parameter(parameter.name(), parameter.value()));
    }
}

