/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;

public class Utils {
    public static boolean isServerUp(String host, Integer port) {
        boolean isUp;
        if ("".equals(host)) {
            isUp = true;
        } else {
            try {
                Socket s = new Socket();
                s.setReuseAddress(true);
                InetSocketAddress sa = new InetSocketAddress(host, (int)port);
                s.connect(sa, 150);
                isUp = true;
            }
            catch (Exception e) {
                isUp = false;
            }
        }
        return isUp;
    }

    public static void removeDirectory(File directory) {
        try {
            Files.walk(directory.toPath(), FileVisitOption.FOLLOW_LINKS).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            Logger.error(e.getMessage());
        }
    }
}

