/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.logger.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;

public class ArtifactoryConnector {
    public static final String INTINO_RELEASES = "https://artifactory.intino.io/artifactory/releases";

    private InputStream connect(URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(2000);
            return connection.getInputStream();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public List<String> consulVersions() {
        try {
            URL url = new URL("https://artifactory.intino.io/artifactory/releases/io/intino/consul/maven-metadata.xml");
            return this.extractVersions(new String(this.read(this.connect(url)).toByteArray()));
        }
        catch (Throwable e) {
            return Collections.emptyList();
        }
    }

    private List<String> extractVersions(String metadata) {
        if (!metadata.contains("<versions>")) {
            return Collections.emptyList();
        }
        metadata = metadata.substring(metadata.indexOf("<versions>")).substring("<versions>".length() + 1);
        metadata = metadata.substring(0, metadata.indexOf("</versions>"));
        metadata = metadata.replace("<version>", "").replace("</version>", "");
        return Arrays.stream(metadata.trim().split("\n")).map(String::trim).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayOutputStream read(InputStream stream) throws Throwable {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (stream == null) {
            return baos;
        }
        try {
            int n;
            byte[] byteChunk = new byte[4096];
            while ((n = stream.read(byteChunk)) > 0) {
                baos.write(byteChunk, 0, n);
            }
        }
        finally {
            stream.close();
        }
        return baos;
    }

    public static class ArtifactoryChecker {
        public static boolean isRunning(String url) {
            try {
                DefaultHttpClient client = new DefaultHttpClient();
                HttpGet request = new HttpGet(url);
                request.addHeader("User-Agent", "User-Agent");
                HttpResponse response = client.execute(request);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode >= 200 && statusCode < 300 || statusCode == 401) {
                    return true;
                }
            }
            catch (IOException e) {
                Logger.error(e);
            }
            return false;
        }
    }

    public static class Version
    implements Comparable<Version> {
        private String version;

        public Version(String version) {
            this.version = version;
        }

        public final String get() {
            return this.version;
        }

        @Override
        public int compareTo(Version that) {
            if (that == null) {
                return 1;
            }
            String[] thisParts = this.get().split("\\.");
            String[] thatParts = that.get().split("\\.");
            int length = Math.max(thisParts.length, thatParts.length);
            for (int i = 0; i < length; ++i) {
                int thatPart;
                int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
                int n = thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0;
                if (thisPart < thatPart) {
                    return -1;
                }
                if (thisPart <= thatPart) continue;
                return 1;
            }
            return 0;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (this.getClass() != that.getClass()) {
                return false;
            }
            return this.compareTo((Version)that) == 0;
        }

        public String toString() {
            return this.version;
        }
    }
}

