/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zet;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zet.ZInputStream;
import io.intino.alexandria.zet.ZetStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class ZetReader
implements ZetStream {
    private final Iterator<Long> iterator;
    private long current = -1L;

    public ZetReader(File file) {
        this(ZetReader.iteratorOf(ZetReader.inputStream(file)));
    }

    public ZetReader(InputStream is) {
        this(ZetReader.iteratorOf(ZetReader.zInputStream(is)));
    }

    public ZetReader(long ... ids) {
        this(Arrays.stream(ids).boxed());
    }

    public ZetReader(List<Long> ids) {
        this(ids.stream());
    }

    @Override
    public long current() {
        return this.current;
    }

    @Override
    public long next() {
        this.current = this.iterator.next();
        return this.current;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public ZetReader(Stream<Long> stream) {
        this(stream.sorted().iterator());
    }

    public ZetReader(Iterator<Long> iterator) {
        this.iterator = iterator;
    }

    private static Iterator<Long> iteratorOf(final ZInputStream stream) {
        return new Iterator<Long>(){
            private long next = this.read();

            @Override
            public Long next() {
                long next = this.next;
                this.next = this.read();
                return next;
            }

            @Override
            public boolean hasNext() {
                return this.next != -1L;
            }

            private long read() {
                try {
                    return stream.readLong();
                }
                catch (IOException e) {
                    this.close();
                    return -1L;
                }
            }

            private void close() {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Logger.error(e);
                }
            }
        };
    }

    private static ZInputStream inputStream(File file) {
        try {
            return ZetReader.zInputStream(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (IOException e) {
            return ZetReader.zInputStream(new ByteArrayInputStream(new byte[0]));
        }
    }

    private static ZInputStream zInputStream(InputStream inputStream) {
        return new ZInputStream(inputStream);
    }
}

