/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ingestion;

import io.intino.alexandria.Fingerprint;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.ingestion.SetSessionWriter;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zet.ZOutputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SetSessionFileWriter
implements SetSessionWriter {
    private final Map<Fingerprint, List<Long>> chunks = new LinkedHashMap<Fingerprint, List<Long>>();
    private final DataOutputStream stream;

    public SetSessionFileWriter(OutputStream outputStream) {
        this.stream = new DataOutputStream(new BufferedOutputStream(outputStream));
    }

    @Override
    public void add(String tank, Timetag timetag, String set, long id) {
        this.check(tank, timetag, set);
        this.add(Fingerprint.of(tank, timetag, set), id);
    }

    private void check(String tank, Timetag timetag, String set) {
        if (tank == null || tank.isEmpty() || timetag == null || set == null || set.isEmpty()) {
            throw new RuntimeException("SetStore: tank, timetag or set is not valid or is empty");
        }
    }

    private void add(Fingerprint fingerprint, long id) {
        if (!this.chunks.containsKey(fingerprint)) {
            this.chunks.put(fingerprint, new ArrayList());
        }
        this.chunks.get(fingerprint).add(id);
    }

    @Override
    public void flush() {
        try {
            this.chunks.forEach(this::write);
            this.chunks.clear();
            this.stream.flush();
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void write(Fingerprint fingerprint, List<Long> ids) {
        try {
            Collections.sort(ids);
            this.write(fingerprint.toString().getBytes());
            this.write(this.dataOf(ids));
            this.stream.flush();
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void write(byte[] data) throws IOException {
        this.stream.writeInt(data.length);
        this.stream.write(data);
    }

    private byte[] dataOf(List<Long> ids) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        ZOutputStream outputStream = new ZOutputStream(data);
        for (long id : ids) {
            outputStream.writeLong(id);
        }
        outputStream.close();
        return data.toByteArray();
    }

    @Override
    public void close() {
        try {
            this.chunks.forEach(this::write);
            this.chunks.clear();
            this.stream.close();
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }
}

