/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.DataConverterException;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonDataConverter
extends DataConverter {
    protected final ObjectMapper mapper;

    public JsonDataConverter() {
        this(new ObjectMapper());
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        this.mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
    }

    public JsonDataConverter(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public String toData(Object value) throws DataConverterException {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (JsonGenerationException e) {
            this.throwDataConverterException(e, value);
        }
        catch (JsonMappingException e) {
            this.throwDataConverterException(e, value);
        }
        catch (IOException e) {
            this.throwDataConverterException(e, value);
        }
        throw new IllegalStateException("not reachable");
    }

    private void throwDataConverterException(Throwable e, Object value) {
        if (value == null) {
            throw new DataConverterException("Failure serializing null value", e);
        }
        throw new DataConverterException("Failure serializing \"" + value + "\" of type \"" + value.getClass() + "\"", e);
    }

    @Override
    public <T> T fromData(String serialized, Class<T> valueType) throws DataConverterException {
        try {
            return this.mapper.readValue(serialized, valueType);
        }
        catch (JsonParseException e) {
            throw new DataConverterException(e);
        }
        catch (JsonMappingException e) {
            throw new DataConverterException(e);
        }
        catch (IOException e) {
            throw new DataConverterException(e);
        }
    }
}

