/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.redshift.AmazonRedshiftAsync;
import com.amazonaws.services.redshift.AmazonRedshiftClient;
import com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest;
import com.amazonaws.services.redshift.model.Cluster;
import com.amazonaws.services.redshift.model.ClusterParameterGroup;
import com.amazonaws.services.redshift.model.ClusterSecurityGroup;
import com.amazonaws.services.redshift.model.ClusterSubnetGroup;
import com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.CreateClusterRequest;
import com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest;
import com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest;
import com.amazonaws.services.redshift.model.DefaultClusterParameters;
import com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.DeleteClusterRequest;
import com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest;
import com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest;
import com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsResult;
import com.amazonaws.services.redshift.model.DescribeClusterParametersRequest;
import com.amazonaws.services.redshift.model.DescribeClusterParametersResult;
import com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsResult;
import com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSnapshotsResult;
import com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsResult;
import com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterVersionsResult;
import com.amazonaws.services.redshift.model.DescribeClustersRequest;
import com.amazonaws.services.redshift.model.DescribeClustersResult;
import com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest;
import com.amazonaws.services.redshift.model.DescribeEventsRequest;
import com.amazonaws.services.redshift.model.DescribeEventsResult;
import com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest;
import com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsResult;
import com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest;
import com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsResult;
import com.amazonaws.services.redshift.model.DescribeReservedNodesRequest;
import com.amazonaws.services.redshift.model.DescribeReservedNodesResult;
import com.amazonaws.services.redshift.model.DescribeResizeRequest;
import com.amazonaws.services.redshift.model.DescribeResizeResult;
import com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.ModifyClusterParameterGroupResult;
import com.amazonaws.services.redshift.model.ModifyClusterRequest;
import com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest;
import com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest;
import com.amazonaws.services.redshift.model.RebootClusterRequest;
import com.amazonaws.services.redshift.model.ReservedNode;
import com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.ResetClusterParameterGroupResult;
import com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest;
import com.amazonaws.services.redshift.model.Snapshot;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonRedshiftAsyncClient
extends AmazonRedshiftClient
implements AmazonRedshiftAsync {
    private ExecutorService executorService;

    public AmazonRedshiftAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonRedshiftAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public AmazonRedshiftAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonRedshiftAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonRedshiftAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonRedshiftAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonRedshiftAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonRedshiftAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newCachedThreadPool());
    }

    public AmazonRedshiftAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<ClusterSubnetGroup> modifyClusterSubnetGroupAsync(final ModifyClusterSubnetGroupRequest modifyClusterSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSubnetGroup>(){

            @Override
            public ClusterSubnetGroup call() throws Exception {
                return AmazonRedshiftAsyncClient.this.modifyClusterSubnetGroup(modifyClusterSubnetGroupRequest);
            }
        });
    }

    @Override
    public Future<ClusterSubnetGroup> modifyClusterSubnetGroupAsync(final ModifyClusterSubnetGroupRequest modifyClusterSubnetGroupRequest, final AsyncHandler<ModifyClusterSubnetGroupRequest, ClusterSubnetGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSubnetGroup>(){

            @Override
            public ClusterSubnetGroup call() throws Exception {
                ClusterSubnetGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.modifyClusterSubnetGroup(modifyClusterSubnetGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyClusterSubnetGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ReservedNode> purchaseReservedNodeOfferingAsync(final PurchaseReservedNodeOfferingRequest purchaseReservedNodeOfferingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReservedNode>(){

            @Override
            public ReservedNode call() throws Exception {
                return AmazonRedshiftAsyncClient.this.purchaseReservedNodeOffering(purchaseReservedNodeOfferingRequest);
            }
        });
    }

    @Override
    public Future<ReservedNode> purchaseReservedNodeOfferingAsync(final PurchaseReservedNodeOfferingRequest purchaseReservedNodeOfferingRequest, final AsyncHandler<PurchaseReservedNodeOfferingRequest, ReservedNode> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReservedNode>(){

            @Override
            public ReservedNode call() throws Exception {
                ReservedNode result;
                try {
                    result = AmazonRedshiftAsyncClient.this.purchaseReservedNodeOffering(purchaseReservedNodeOfferingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(purchaseReservedNodeOfferingRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> modifyClusterAsync(final ModifyClusterRequest modifyClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                return AmazonRedshiftAsyncClient.this.modifyCluster(modifyClusterRequest);
            }
        });
    }

    @Override
    public Future<Cluster> modifyClusterAsync(final ModifyClusterRequest modifyClusterRequest, final AsyncHandler<ModifyClusterRequest, Cluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.modifyCluster(modifyClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyClusterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ModifyClusterParameterGroupResult> modifyClusterParameterGroupAsync(final ModifyClusterParameterGroupRequest modifyClusterParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyClusterParameterGroupResult>(){

            @Override
            public ModifyClusterParameterGroupResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.modifyClusterParameterGroup(modifyClusterParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<ModifyClusterParameterGroupResult> modifyClusterParameterGroupAsync(final ModifyClusterParameterGroupRequest modifyClusterParameterGroupRequest, final AsyncHandler<ModifyClusterParameterGroupRequest, ModifyClusterParameterGroupResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyClusterParameterGroupResult>(){

            @Override
            public ModifyClusterParameterGroupResult call() throws Exception {
                ModifyClusterParameterGroupResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.modifyClusterParameterGroup(modifyClusterParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyClusterParameterGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterSecurityGroupsResult> describeClusterSecurityGroupsAsync(final DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterSecurityGroupsResult>(){

            @Override
            public DescribeClusterSecurityGroupsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeClusterSecurityGroups(describeClusterSecurityGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeClusterSecurityGroupsResult> describeClusterSecurityGroupsAsync(final DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest, final AsyncHandler<DescribeClusterSecurityGroupsRequest, DescribeClusterSecurityGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterSecurityGroupsResult>(){

            @Override
            public DescribeClusterSecurityGroupsResult call() throws Exception {
                DescribeClusterSecurityGroupsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterSecurityGroups(describeClusterSecurityGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeClusterSecurityGroupsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> copyClusterSnapshotAsync(final CopyClusterSnapshotRequest copyClusterSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                return AmazonRedshiftAsyncClient.this.copyClusterSnapshot(copyClusterSnapshotRequest);
            }
        });
    }

    @Override
    public Future<Snapshot> copyClusterSnapshotAsync(final CopyClusterSnapshotRequest copyClusterSnapshotRequest, final AsyncHandler<CopyClusterSnapshotRequest, Snapshot> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonRedshiftAsyncClient.this.copyClusterSnapshot(copyClusterSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(copyClusterSnapshotRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOrderableClusterOptionsResult> describeOrderableClusterOptionsAsync(final DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeOrderableClusterOptionsResult>(){

            @Override
            public DescribeOrderableClusterOptionsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeOrderableClusterOptions(describeOrderableClusterOptionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeOrderableClusterOptionsResult> describeOrderableClusterOptionsAsync(final DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest, final AsyncHandler<DescribeOrderableClusterOptionsRequest, DescribeOrderableClusterOptionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeOrderableClusterOptionsResult>(){

            @Override
            public DescribeOrderableClusterOptionsResult call() throws Exception {
                DescribeOrderableClusterOptionsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeOrderableClusterOptions(describeOrderableClusterOptionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeOrderableClusterOptionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ClusterSubnetGroup> createClusterSubnetGroupAsync(final CreateClusterSubnetGroupRequest createClusterSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSubnetGroup>(){

            @Override
            public ClusterSubnetGroup call() throws Exception {
                return AmazonRedshiftAsyncClient.this.createClusterSubnetGroup(createClusterSubnetGroupRequest);
            }
        });
    }

    @Override
    public Future<ClusterSubnetGroup> createClusterSubnetGroupAsync(final CreateClusterSubnetGroupRequest createClusterSubnetGroupRequest, final AsyncHandler<CreateClusterSubnetGroupRequest, ClusterSubnetGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSubnetGroup>(){

            @Override
            public ClusterSubnetGroup call() throws Exception {
                ClusterSubnetGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createClusterSubnetGroup(createClusterSubnetGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createClusterSubnetGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> rebootClusterAsync(final RebootClusterRequest rebootClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                return AmazonRedshiftAsyncClient.this.rebootCluster(rebootClusterRequest);
            }
        });
    }

    @Override
    public Future<Cluster> rebootClusterAsync(final RebootClusterRequest rebootClusterRequest, final AsyncHandler<RebootClusterRequest, Cluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.rebootCluster(rebootClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(rebootClusterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteClusterSubnetGroupAsync(final DeleteClusterSubnetGroupRequest deleteClusterSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRedshiftAsyncClient.this.deleteClusterSubnetGroup(deleteClusterSubnetGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteClusterSubnetGroupAsync(final DeleteClusterSubnetGroupRequest deleteClusterSubnetGroupRequest, final AsyncHandler<DeleteClusterSubnetGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRedshiftAsyncClient.this.deleteClusterSubnetGroup(deleteClusterSubnetGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteClusterSubnetGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeClusterSubnetGroupsResult> describeClusterSubnetGroupsAsync(final DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterSubnetGroupsResult>(){

            @Override
            public DescribeClusterSubnetGroupsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeClusterSubnetGroups(describeClusterSubnetGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeClusterSubnetGroupsResult> describeClusterSubnetGroupsAsync(final DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest, final AsyncHandler<DescribeClusterSubnetGroupsRequest, DescribeClusterSubnetGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterSubnetGroupsResult>(){

            @Override
            public DescribeClusterSubnetGroupsResult call() throws Exception {
                DescribeClusterSubnetGroupsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterSubnetGroups(describeClusterSubnetGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeClusterSubnetGroupsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> createClusterSnapshotAsync(final CreateClusterSnapshotRequest createClusterSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                return AmazonRedshiftAsyncClient.this.createClusterSnapshot(createClusterSnapshotRequest);
            }
        });
    }

    @Override
    public Future<Snapshot> createClusterSnapshotAsync(final CreateClusterSnapshotRequest createClusterSnapshotRequest, final AsyncHandler<CreateClusterSnapshotRequest, Snapshot> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createClusterSnapshot(createClusterSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createClusterSnapshotRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> deleteClusterAsync(final DeleteClusterRequest deleteClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                return AmazonRedshiftAsyncClient.this.deleteCluster(deleteClusterRequest);
            }
        });
    }

    @Override
    public Future<Cluster> deleteClusterAsync(final DeleteClusterRequest deleteClusterRequest, final AsyncHandler<DeleteClusterRequest, Cluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.deleteCluster(deleteClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteClusterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> createClusterAsync(final CreateClusterRequest createClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                return AmazonRedshiftAsyncClient.this.createCluster(createClusterRequest);
            }
        });
    }

    @Override
    public Future<Cluster> createClusterAsync(final CreateClusterRequest createClusterRequest, final AsyncHandler<CreateClusterRequest, Cluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createCluster(createClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createClusterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> deleteClusterSnapshotAsync(final DeleteClusterSnapshotRequest deleteClusterSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                return AmazonRedshiftAsyncClient.this.deleteClusterSnapshot(deleteClusterSnapshotRequest);
            }
        });
    }

    @Override
    public Future<Snapshot> deleteClusterSnapshotAsync(final DeleteClusterSnapshotRequest deleteClusterSnapshotRequest, final AsyncHandler<DeleteClusterSnapshotRequest, Snapshot> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonRedshiftAsyncClient.this.deleteClusterSnapshot(deleteClusterSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteClusterSnapshotRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteClusterParameterGroupAsync(final DeleteClusterParameterGroupRequest deleteClusterParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRedshiftAsyncClient.this.deleteClusterParameterGroup(deleteClusterParameterGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteClusterParameterGroupAsync(final DeleteClusterParameterGroupRequest deleteClusterParameterGroupRequest, final AsyncHandler<DeleteClusterParameterGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRedshiftAsyncClient.this.deleteClusterParameterGroup(deleteClusterParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteClusterParameterGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ClusterSecurityGroup> authorizeClusterSecurityGroupIngressAsync(final AuthorizeClusterSecurityGroupIngressRequest authorizeClusterSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSecurityGroup>(){

            @Override
            public ClusterSecurityGroup call() throws Exception {
                return AmazonRedshiftAsyncClient.this.authorizeClusterSecurityGroupIngress(authorizeClusterSecurityGroupIngressRequest);
            }
        });
    }

    @Override
    public Future<ClusterSecurityGroup> authorizeClusterSecurityGroupIngressAsync(final AuthorizeClusterSecurityGroupIngressRequest authorizeClusterSecurityGroupIngressRequest, final AsyncHandler<AuthorizeClusterSecurityGroupIngressRequest, ClusterSecurityGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSecurityGroup>(){

            @Override
            public ClusterSecurityGroup call() throws Exception {
                ClusterSecurityGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.authorizeClusterSecurityGroupIngress(authorizeClusterSecurityGroupIngressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(authorizeClusterSecurityGroupIngressRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest describeEventsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeEvents(describeEventsRequest);
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest describeEventsRequest, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeEvents(describeEventsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeEventsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteClusterSecurityGroupAsync(final DeleteClusterSecurityGroupRequest deleteClusterSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRedshiftAsyncClient.this.deleteClusterSecurityGroup(deleteClusterSecurityGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteClusterSecurityGroupAsync(final DeleteClusterSecurityGroupRequest deleteClusterSecurityGroupRequest, final AsyncHandler<DeleteClusterSecurityGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonRedshiftAsyncClient.this.deleteClusterSecurityGroup(deleteClusterSecurityGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteClusterSecurityGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeReservedNodesResult> describeReservedNodesAsync(final DescribeReservedNodesRequest describeReservedNodesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedNodesResult>(){

            @Override
            public DescribeReservedNodesResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeReservedNodes(describeReservedNodesRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedNodesResult> describeReservedNodesAsync(final DescribeReservedNodesRequest describeReservedNodesRequest, final AsyncHandler<DescribeReservedNodesRequest, DescribeReservedNodesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedNodesResult>(){

            @Override
            public DescribeReservedNodesResult call() throws Exception {
                DescribeReservedNodesResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeReservedNodes(describeReservedNodesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeReservedNodesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ResetClusterParameterGroupResult> resetClusterParameterGroupAsync(final ResetClusterParameterGroupRequest resetClusterParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ResetClusterParameterGroupResult>(){

            @Override
            public ResetClusterParameterGroupResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.resetClusterParameterGroup(resetClusterParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<ResetClusterParameterGroupResult> resetClusterParameterGroupAsync(final ResetClusterParameterGroupRequest resetClusterParameterGroupRequest, final AsyncHandler<ResetClusterParameterGroupRequest, ResetClusterParameterGroupResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ResetClusterParameterGroupResult>(){

            @Override
            public ResetClusterParameterGroupResult call() throws Exception {
                ResetClusterParameterGroupResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.resetClusterParameterGroup(resetClusterParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(resetClusterParameterGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DefaultClusterParameters> describeDefaultClusterParametersAsync(final DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DefaultClusterParameters>(){

            @Override
            public DefaultClusterParameters call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeDefaultClusterParameters(describeDefaultClusterParametersRequest);
            }
        });
    }

    @Override
    public Future<DefaultClusterParameters> describeDefaultClusterParametersAsync(final DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest, final AsyncHandler<DescribeDefaultClusterParametersRequest, DefaultClusterParameters> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DefaultClusterParameters>(){

            @Override
            public DefaultClusterParameters call() throws Exception {
                DefaultClusterParameters result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeDefaultClusterParameters(describeDefaultClusterParametersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeDefaultClusterParametersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ClusterSecurityGroup> createClusterSecurityGroupAsync(final CreateClusterSecurityGroupRequest createClusterSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSecurityGroup>(){

            @Override
            public ClusterSecurityGroup call() throws Exception {
                return AmazonRedshiftAsyncClient.this.createClusterSecurityGroup(createClusterSecurityGroupRequest);
            }
        });
    }

    @Override
    public Future<ClusterSecurityGroup> createClusterSecurityGroupAsync(final CreateClusterSecurityGroupRequest createClusterSecurityGroupRequest, final AsyncHandler<CreateClusterSecurityGroupRequest, ClusterSecurityGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSecurityGroup>(){

            @Override
            public ClusterSecurityGroup call() throws Exception {
                ClusterSecurityGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createClusterSecurityGroup(createClusterSecurityGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createClusterSecurityGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedNodeOfferingsResult> describeReservedNodeOfferingsAsync(final DescribeReservedNodeOfferingsRequest describeReservedNodeOfferingsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedNodeOfferingsResult>(){

            @Override
            public DescribeReservedNodeOfferingsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeReservedNodeOfferings(describeReservedNodeOfferingsRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedNodeOfferingsResult> describeReservedNodeOfferingsAsync(final DescribeReservedNodeOfferingsRequest describeReservedNodeOfferingsRequest, final AsyncHandler<DescribeReservedNodeOfferingsRequest, DescribeReservedNodeOfferingsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedNodeOfferingsResult>(){

            @Override
            public DescribeReservedNodeOfferingsResult call() throws Exception {
                DescribeReservedNodeOfferingsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeReservedNodeOfferings(describeReservedNodeOfferingsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeReservedNodeOfferingsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeResizeResult> describeResizeAsync(final DescribeResizeRequest describeResizeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeResizeResult>(){

            @Override
            public DescribeResizeResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeResize(describeResizeRequest);
            }
        });
    }

    @Override
    public Future<DescribeResizeResult> describeResizeAsync(final DescribeResizeRequest describeResizeRequest, final AsyncHandler<DescribeResizeRequest, DescribeResizeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeResizeResult>(){

            @Override
            public DescribeResizeResult call() throws Exception {
                DescribeResizeResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeResize(describeResizeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeResizeRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterVersionsResult> describeClusterVersionsAsync(final DescribeClusterVersionsRequest describeClusterVersionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterVersionsResult>(){

            @Override
            public DescribeClusterVersionsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeClusterVersions(describeClusterVersionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeClusterVersionsResult> describeClusterVersionsAsync(final DescribeClusterVersionsRequest describeClusterVersionsRequest, final AsyncHandler<DescribeClusterVersionsRequest, DescribeClusterVersionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterVersionsResult>(){

            @Override
            public DescribeClusterVersionsResult call() throws Exception {
                DescribeClusterVersionsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterVersions(describeClusterVersionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeClusterVersionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterParametersResult> describeClusterParametersAsync(final DescribeClusterParametersRequest describeClusterParametersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterParametersResult>(){

            @Override
            public DescribeClusterParametersResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeClusterParameters(describeClusterParametersRequest);
            }
        });
    }

    @Override
    public Future<DescribeClusterParametersResult> describeClusterParametersAsync(final DescribeClusterParametersRequest describeClusterParametersRequest, final AsyncHandler<DescribeClusterParametersRequest, DescribeClusterParametersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterParametersResult>(){

            @Override
            public DescribeClusterParametersResult call() throws Exception {
                DescribeClusterParametersResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterParameters(describeClusterParametersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeClusterParametersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ClusterSecurityGroup> revokeClusterSecurityGroupIngressAsync(final RevokeClusterSecurityGroupIngressRequest revokeClusterSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSecurityGroup>(){

            @Override
            public ClusterSecurityGroup call() throws Exception {
                return AmazonRedshiftAsyncClient.this.revokeClusterSecurityGroupIngress(revokeClusterSecurityGroupIngressRequest);
            }
        });
    }

    @Override
    public Future<ClusterSecurityGroup> revokeClusterSecurityGroupIngressAsync(final RevokeClusterSecurityGroupIngressRequest revokeClusterSecurityGroupIngressRequest, final AsyncHandler<RevokeClusterSecurityGroupIngressRequest, ClusterSecurityGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterSecurityGroup>(){

            @Override
            public ClusterSecurityGroup call() throws Exception {
                ClusterSecurityGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.revokeClusterSecurityGroupIngress(revokeClusterSecurityGroupIngressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(revokeClusterSecurityGroupIngressRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(final DescribeClustersRequest describeClustersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClustersResult>(){

            @Override
            public DescribeClustersResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeClusters(describeClustersRequest);
            }
        });
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(final DescribeClustersRequest describeClustersRequest, final AsyncHandler<DescribeClustersRequest, DescribeClustersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClustersResult>(){

            @Override
            public DescribeClustersResult call() throws Exception {
                DescribeClustersResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusters(describeClustersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeClustersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterSnapshotsResult> describeClusterSnapshotsAsync(final DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterSnapshotsResult>(){

            @Override
            public DescribeClusterSnapshotsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeClusterSnapshots(describeClusterSnapshotsRequest);
            }
        });
    }

    @Override
    public Future<DescribeClusterSnapshotsResult> describeClusterSnapshotsAsync(final DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest, final AsyncHandler<DescribeClusterSnapshotsRequest, DescribeClusterSnapshotsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterSnapshotsResult>(){

            @Override
            public DescribeClusterSnapshotsResult call() throws Exception {
                DescribeClusterSnapshotsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterSnapshots(describeClusterSnapshotsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeClusterSnapshotsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ClusterParameterGroup> createClusterParameterGroupAsync(final CreateClusterParameterGroupRequest createClusterParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterParameterGroup>(){

            @Override
            public ClusterParameterGroup call() throws Exception {
                return AmazonRedshiftAsyncClient.this.createClusterParameterGroup(createClusterParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<ClusterParameterGroup> createClusterParameterGroupAsync(final CreateClusterParameterGroupRequest createClusterParameterGroupRequest, final AsyncHandler<CreateClusterParameterGroupRequest, ClusterParameterGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ClusterParameterGroup>(){

            @Override
            public ClusterParameterGroup call() throws Exception {
                ClusterParameterGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createClusterParameterGroup(createClusterParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createClusterParameterGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterParameterGroupsResult> describeClusterParameterGroupsAsync(final DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterParameterGroupsResult>(){

            @Override
            public DescribeClusterParameterGroupsResult call() throws Exception {
                return AmazonRedshiftAsyncClient.this.describeClusterParameterGroups(describeClusterParameterGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeClusterParameterGroupsResult> describeClusterParameterGroupsAsync(final DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest, final AsyncHandler<DescribeClusterParameterGroupsRequest, DescribeClusterParameterGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterParameterGroupsResult>(){

            @Override
            public DescribeClusterParameterGroupsResult call() throws Exception {
                DescribeClusterParameterGroupsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterParameterGroups(describeClusterParameterGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeClusterParameterGroupsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> restoreFromClusterSnapshotAsync(final RestoreFromClusterSnapshotRequest restoreFromClusterSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                return AmazonRedshiftAsyncClient.this.restoreFromClusterSnapshot(restoreFromClusterSnapshotRequest);
            }
        });
    }

    @Override
    public Future<Cluster> restoreFromClusterSnapshotAsync(final RestoreFromClusterSnapshotRequest restoreFromClusterSnapshotRequest, final AsyncHandler<RestoreFromClusterSnapshotRequest, Cluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.restoreFromClusterSnapshot(restoreFromClusterSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(restoreFromClusterSnapshotRequest, result);
                return result;
            }
        });
    }
}

