/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.io;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.serializers.DeflateSerializer;
import com.esotericsoftware.minlog.Log;
import io.intino.magritte.io.Deserializer;
import io.intino.magritte.io.LocalDateTimeSerializer;
import io.intino.magritte.io.Stash;
import java.io.File;
import java.io.InputStream;
import java.time.LocalDateTime;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class StashDeserializer
extends Deserializer {
    private StashDeserializer() {
    }

    public static Stash stashFrom(File file) {
        return StashDeserializer.stashFrom(StashDeserializer.bytesFrom(file));
    }

    public static Stash stashFrom(InputStream inputStream) {
        return StashDeserializer.stashFrom(StashDeserializer.bytesFrom(inputStream));
    }

    public static Stash stashFrom(byte[] bytes) {
        Stash result = null;
        try (Input input = new Input(bytes);){
            Kryo kryo = new Kryo();
            kryo.setInstantiatorStrategy(new Kryo.DefaultInstantiatorStrategy(new StdInstantiatorStrategy()));
            kryo.register(Stash.class, new DeflateSerializer(kryo.getDefaultSerializer(Stash.class)));
            kryo.register(LocalDateTime.class, new LocalDateTimeSerializer());
            result = kryo.readObject(input, Stash.class);
        }
        catch (Throwable e) {
            Log.error(e.getMessage());
        }
        return result;
    }

    static {
        Log.ERROR();
    }
}

