/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.sigar;

import io.intino.alexandria.logger.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class SigarServerManager {
    private Sigar sigar = new Sigar();

    public double usedCPUUsagePercent() throws IOException {
        try {
            return SigarServerManager.asPercent(this.sigar.getCpuPerc().getUser());
        }
        catch (SigarException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public double usedMemoryPercent() throws IOException {
        try {
            double usedPercent = this.sigar.getMem().getUsedPercent();
            return SigarServerManager.asPercent(usedPercent > 1.0 ? usedPercent : usedPercent * 100.0);
        }
        catch (SigarException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public double memoryCapacity() {
        try {
            return this.sigar.getMem().getTotal() / 0x100000L;
        }
        catch (SigarException e) {
            return 0.0;
        }
    }

    public long hddCapacity() {
        try {
            FileSystemUsage usage = this.fileSystemUsage();
            return usage.getTotal() / 1024L;
        }
        catch (SigarException e) {
            return 0L;
        }
    }

    public double directorySize(String directory) {
        try {
            return this.sigar.getDirUsage(directory).getDiskUsage() / 0x100000L;
        }
        catch (SigarException e) {
            return 0.0;
        }
    }

    public double directoryTotalSize(String directory) {
        try {
            String line;
            if (!new File(directory).exists()) {
                return 0.0;
            }
            Process p = Runtime.getRuntime().exec("du -s " + directory);
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
            }
            String text = builder.toString();
            return Double.parseDouble(text.substring(0, text.indexOf("\t"))) / 1024.0;
        }
        catch (IOException | InterruptedException | NumberFormatException e) {
            return 0.0;
        }
    }

    private FileSystemUsage fileSystemUsage() throws SigarException {
        FileSystem fileSystem = this.fileSystem();
        if (fileSystem == null) {
            fileSystem = this.sigar.getFileSystemList()[0];
        }
        return this.sigar.getFileSystemUsage(fileSystem.getDirName());
    }

    private FileSystem fileSystem() throws SigarException {
        return Arrays.stream(this.sigar.getFileSystemList()).filter(f -> f.getDirName().equals("/")).findFirst().orElse(null);
    }

    public int cores() {
        try {
            return this.sigar.getCpuInfoList().length;
        }
        catch (SigarException e) {
            return 0;
        }
    }

    public double usedHDDUsagePercent() throws IOException {
        try {
            FileSystemUsage usage = this.fileSystemUsage();
            return SigarServerManager.asPercent(usage.getUsePercent() > 1.0 ? usage.getUsePercent() : usage.getUsePercent() * 100.0);
        }
        catch (SigarException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public int inboundConnections() throws IOException {
        try {
            return this.sigar.getNetStat().getAllInboundTotal();
        }
        catch (SigarException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public int outboundConnections() throws IOException {
        try {
            return this.sigar.getNetStat().getAllOutboundTotal();
        }
        catch (SigarException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public int openFiles() throws IOException {
        try {
            return (int)this.sigar.getResourceLimit().getOpenFilesCur();
        }
        catch (SigarException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public int maxOpenFiles() {
        try {
            return (int)this.sigar.getResourceLimit().getOpenFilesMax();
        }
        catch (SigarException e) {
            Logger.error(e);
            return 0;
        }
    }

    public int openFiles(int process) {
        try {
            return (int)this.sigar.getProcFd(process).getTotal();
        }
        catch (SigarException e) {
            Logger.error(e);
            return 0;
        }
    }

    private static double asPercent(double number) {
        return Math.floor(number * 100.0) / 100.0;
    }
}

