/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.service.requests;

import io.intino.alexandria.event.EventHub;
import io.intino.alexandria.logger.Logger;
import io.intino.cesar.datahub.events.ServerStatus;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.StatusAction;

public class StatusRequest
implements EventHub.RequestConsumer {
    private ConsulBox box;

    public StatusRequest(ConsulBox box) {
        this.box = box;
    }

    @Override
    public String accept(String request) {
        try {
            ServerStatus status = this.actionFor().execute();
            this.feed(status);
            return status.toString();
        }
        catch (Throwable e) {
            Logger.error(e);
            return null;
        }
    }

    private void feed(ServerStatus status) {
        this.box.terminal().publish(status);
    }

    private StatusAction actionFor() {
        StatusAction action = new StatusAction();
        action.box = this.box;
        return action;
    }
}

