/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.service.requests;

import io.intino.alexandria.event.EventHub;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageReader;
import io.intino.cesar.datahub.events.ProcessStatus;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.ProcessStatusAction;

public class ProcessStatusRequest
implements EventHub.RequestConsumer {
    private ConsulBox box;

    public ProcessStatusRequest(ConsulBox box) {
        this.box = box;
    }

    @Override
    public String accept(String request) {
        try {
            ProcessStatus status = this.actionFor(this.processId(request)).execute();
            this.feed(status);
            return status.toString();
        }
        catch (Throwable e) {
            Logger.error(e.getMessage(), e);
            return null;
        }
    }

    private void feed(ProcessStatus status) {
        this.box.terminal().publish(status);
    }

    private String processId(String request) {
        return new MessageReader(request).next().get("processId").asString();
    }

    private ProcessStatusAction actionFor(String processId) {
        ProcessStatusAction action = new ProcessStatusAction();
        action.box = this.box;
        action.processId = processId;
        return action;
    }
}

