/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.service.requests;

import io.intino.alexandria.event.EventHub;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageReader;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.ProcessLogAction;

public class ProcessLogRequest
implements EventHub.RequestConsumer {
    private ConsulBox box;

    public ProcessLogRequest(ConsulBox box) {
        this.box = box;
    }

    @Override
    public String accept(String request) {
        try {
            return this.actionFor(this.processId(request)).execute().toString();
        }
        catch (Throwable e) {
            Logger.error(e);
            return null;
        }
    }

    private String processId(String request) {
        return new MessageReader(request).next().get("processId").asString();
    }

    private ProcessLogAction actionFor(String processId) {
        ProcessLogAction action = new ProcessLogAction();
        action.box = this.box;
        action.processId = processId;
        return action;
    }
}

