/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.process;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageBuilder;
import io.intino.cesar.datahub.ConsulTerminal;
import io.intino.cesar.datahub.events.ProcessLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

public class ProcessLogHandler {
    public static final String EXITED_TEXT = "Process exited with code: ";
    private final String serverId;
    private final File logsDirectory;
    private final ConsulTerminal terminal;
    private Map<io.intino.consul.graph.Process, EventLogReader> processes = new HashMap<io.intino.consul.graph.Process, EventLogReader>();

    public ProcessLogHandler(String serverId, File logsDirectory, ConsulTerminal terminal) {
        this.serverId = serverId;
        this.logsDirectory = logsDirectory;
        this.terminal = terminal;
    }

    void log(io.intino.consul.graph.Process process, Process systemProcess) {
        EventLogReader reader = new EventLogReader(process, systemProcess);
        this.processes.put(process, reader);
        reader.start();
    }

    private void release(io.intino.consul.graph.Process process) {
        EventLogReader eventLogReader = this.processes.get(process);
        if (eventLogReader != null) {
            eventLogReader.stop();
        }
        this.processes.remove(process);
    }

    public String lastExecutionLog(io.intino.consul.graph.Process process) {
        return this.lastExecutionLog(this.logFile(process).toPath());
    }

    private String lastExecutionLog(Path path) {
        try {
            String text = Files.readString(path, StandardCharsets.UTF_8);
            int contains = text.lastIndexOf(EXITED_TEXT);
            if (contains > 0) {
                String substring = text.substring(contains);
                return substring.substring(substring.indexOf("\n") + 1);
            }
            return text;
        }
        catch (IOException e) {
            Logger.error(e.getMessage(), e);
            return "";
        }
    }

    private File logFile(io.intino.consul.graph.Process process) {
        return new File(this.logsDirectory, process.logFileName());
    }

    private class EventLogReader {
        private io.intino.consul.graph.Process process;
        private Thread thread;

        EventLogReader(io.intino.consul.graph.Process process, Process systemProcess) {
            this.process = process;
            this.thread = new Thread(new ThreadGroup("loggers"), () -> {
                this.sniff(systemProcess);
                ProcessLogHandler.this.release(process);
            }, "logger of " + process.artifact());
        }

        void start() {
            this.thread.start();
        }

        void stop() {
            if (!this.thread.isInterrupted()) {
                this.thread.interrupt();
            }
        }

        private void sniff(Process process) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder builder = new StringBuilder();
            boolean onExit = false;
            while (true) {
                if (onExit) {
                    this.sendMessage(ProcessLogHandler.EXITED_TEXT + process.exitValue());
                    return;
                }
                if (!process.isAlive()) {
                    onExit = true;
                }
                this.read(reader, builder);
                if (!builder.toString().isEmpty()) {
                    String newLog = builder.toString();
                    this.sendMessage(newLog);
                    builder = new StringBuilder();
                }
                this.sleep();
            }
        }

        private void sleep() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void read(BufferedReader reader, StringBuilder builder) {
            try {
                Thread thread = this.readLineThread(reader, builder);
                thread.start();
                thread.join(500L);
            }
            catch (InterruptedException e) {
                Logger.error(e.getMessage());
            }
        }

        private Thread readLineThread(BufferedReader reader, StringBuilder builder) {
            return new Thread(() -> {
                try {
                    String line;
                    while (reader.ready() && (line = reader.readLine()) != null) {
                        builder.append(line);
                        builder.append(System.getProperty("line.separator"));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }

        private void sendMessage(String log) {
            ProcessLog processLog = this.newLog(log.trim().replaceAll("message:[ ]?\n\t\n", "message: "));
            try {
                this.saveLog(processLog);
            }
            catch (IOException e) {
                Logger.error(e.getMessage());
            }
            ProcessLogHandler.this.terminal.publish(new ProcessLog(MessageBuilder.toMessage(processLog)));
        }

        private void saveLog(ProcessLog processLog) throws IOException {
            File file = ProcessLogHandler.this.logFile(this.process);
            long size = file.length() / 0x100000L;
            if (size >= 25L) {
                this.truncate(file);
            }
            Files.write(file.toPath(), (processLog.value() + "\n\n").getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }

        private void truncate(File file) {
            try {
                String messages = new String(Files.readAllBytes(file.toPath()));
                Files.write(file.toPath(), messages.substring(messages.length() / 2).getBytes(), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                Logger.error(e.getMessage(), e);
            }
        }

        private ProcessLog newLog(String log) {
            return new ProcessLog().ts(Instant.now()).serverId(ProcessLogHandler.this.serverId).id(this.process.identifier()).value(log);
        }
    }
}

