/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.process;

import com.sun.management.OperatingSystemMXBean;
import com.sun.management.ThreadMXBean;
import io.intino.alexandria.jmx.JMXClient;
import io.intino.cesar.datahub.events.OperationResult;
import io.intino.cesar.datahub.events.Operations;
import io.intino.cesar.datahub.events.ProcessStatus;
import io.intino.consul.box.process.Parsers;
import io.intino.consul.box.sigar.SigarServerManager;
import io.intino.consul.graph.Process;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;

public class ProcessConnector {
    private static final String CONNECTOR = "com.sun.management.jmxremote.localConnectorAddress";
    private JMXClient.JMXConnection connection = null;
    private Process process;

    public ProcessConnector(Process process) {
        this.process = process;
    }

    private static double truncate(double number) {
        return Math.floor(number * 100.0) / 100.0;
    }

    public void connect() throws IOException {
        this.connection = new JMXClient("localhost", this.process.managementPort()).connect();
    }

    public void close() {
        this.connection.close();
    }

    public ProcessStatus status() {
        ProcessStatus status = new ProcessStatus().ts(Instant.now()).running(true);
        if (this.connection == null) {
            return null;
        }
        MemoryMXBean memoryMXBean = this.connection.mBean(MemoryMXBean.class, ManagementFactory.getMemoryMXBean().getObjectName());
        OperatingSystemMXBean osMXBean = this.connection.mBean(OperatingSystemMXBean.class, ManagementFactory.getOperatingSystemMXBean().getObjectName());
        ThreadMXBean threadMBean = this.connection.mBean(ThreadMXBean.class, ManagementFactory.getThreadMXBean().getObjectName());
        SigarServerManager manager = new SigarServerManager();
        status.workspaceSize(manager.directorySize(this.process.workspace()));
        status.workspaceTotalSize(manager.directoryTotalSize(this.process.workspace()));
        status.openFiles(manager.openFiles(this.process.pid()));
        return status.memory(ProcessConnector.truncate(memoryMXBean.getHeapMemoryUsage().getUsed() / 0x100000L)).cpu(ProcessConnector.truncate(osMXBean.getProcessCpuLoad() * 100.0)).threads(threadMBean.getThreadCount());
    }

    public List<String> operations() {
        Map<MBeanOperationInfo, String> info = this.connection.operationInfos(this.connection.findObjectName("Konos"));
        MBeanOperationInfo op = info.keySet().stream().filter(i -> i.getName().equals("help")).findFirst().orElse(null);
        ObjectName konos = this.connection.findObjectName("Konos");
        if (konos == null) {
            return Collections.emptyList();
        }
        return (List)this.connection.invokeOperation(konos, op, new Object[0]);
    }

    public OperationResult invoke(Operations.Operation operation) {
        Object[] objectArray;
        Map<MBeanOperationInfo, String> info = this.connection.operationInfos(this.connection.findObjectName("Konos"));
        MBeanOperationInfo op = info.keySet().stream().filter(i -> i.getName().equals(operation.name())).findFirst().orElse(null);
        if (op.getSignature().length > 0 && op.getSignature()[0].getType().contains("List")) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = operation.parameters();
        } else {
            objectArray = this.transform(op.getSignature(), operation.parameters());
        }
        Object[] parameters = objectArray;
        Object result = this.connection.invokeOperation(this.connection.findObjectName("Konos"), op, parameters);
        OperationResult success = new OperationResult().success(true);
        return success.remarks(result instanceof List ? (String)((List)result).stream().map(Object::toString).reduce((t, u) -> t + "\n" + u).get() : result.toString());
    }

    private Object[] transform(MBeanParameterInfo[] paramters, List<String> parameters) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (int i = 0; i < paramters.length; ++i) {
            MBeanParameterInfo parameter = paramters[i];
            if (parameter.getType().equals(String.class.getName())) {
                objects.add(parameters.get(i));
                continue;
            }
            Parsers.Parser parser = this.getParser(parameter);
            if (parser == null) {
                return new Object[0];
            }
            objects.add(parser.parse(parameters.get(i)));
        }
        return objects.toArray();
    }

    private Parsers.Parser getParser(MBeanParameterInfo parameter) {
        try {
            return TypeParsers.get(Class.forName(parameter.getType()));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static class TypeParsers {
        private static final Map<Class, Parsers.Parser> parsers = new HashMap<Class, Parsers.Parser>();

        public static Parsers.Parser get(Class<?> aClass) {
            return parsers.get(aClass);
        }

        static {
            parsers.put(Boolean.TYPE, Boolean::parseBoolean);
            parsers.put(Byte.TYPE, Byte::parseByte);
            parsers.put(Integer.TYPE, Integer::parseInt);
            parsers.put(Float.TYPE, Float::parseFloat);
            parsers.put(Double.TYPE, Double::parseDouble);
            parsers.put(Long.TYPE, Long::parseLong);
            parsers.put(Boolean.class, parsers.get(Boolean.TYPE));
            parsers.put(Byte.class, parsers.get(Byte.TYPE));
            parsers.put(Integer.class, parsers.get(Integer.TYPE));
            parsers.put(Long.class, parsers.get(Long.TYPE));
            parsers.put(Float.class, parsers.get(Float.TYPE));
            parsers.put(Double.class, parsers.get(Double.TYPE));
            parsers.put(String.class, text -> text);
            parsers.put(Instant.class, Instant::parse);
        }
    }
}

