/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.Store;
import io.intino.magritte.framework.stores.InMemoryFileStore;
import io.intino.magritte.io.Stash;
import java.io.File;
import org.apache.log4j.Level;

public class Main {
    public static void main(String[] args) {
        io.intino.alexandria.logger4j.Logger.setLevel(Level.ERROR);
        ConsulConfiguration configuration = new ConsulConfiguration(args);
        ConsulBox box = (ConsulBox)new ConsulBox(configuration).put(Main.loadGraph(configuration)).start();
        if (box.terminal() == null) {
            Logger.error("Event Hub couldn't init");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(box::stop));
    }

    private static Graph loadGraph(ConsulConfiguration configuration) {
        return new Graph(Main.store(configuration)).loadStashes("Consul");
    }

    private static Store store(ConsulConfiguration configuration) {
        return new InMemoryFileStore(new File(configuration.home(), "store")){

            @Override
            public void writeStash(Stash stash, String path) {
                stash.language = stash.language == null || stash.language.isEmpty() ? "Consul" : stash.language;
                super.writeStash(stash, path);
            }
        };
    }
}

