/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import com.jcabi.aether.Aether;
import io.intino.consul.box.ArtifactoryConnector;
import io.intino.consul.graph.Process;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.resolution.DependencyResolutionException;

public class LibraryResolver {
    public static final String MAVEN_REPOSITORY = "https://repo1.maven.org/maven2/";
    private Aether aether;

    public LibraryResolver(File localRepository, List<Process.Artifact.Artifactory> artifactories) {
        List<RemoteRepository> repositories = artifactories.stream().filter(a -> ArtifactoryConnector.ArtifactoryChecker.isRunning(a.url())).distinct().map(artifactory -> new RemoteRepository(artifactory.mavenId(), "default", artifactory.url()).setPolicy(false, new RepositoryPolicy().setEnabled(true))).collect(Collectors.toList());
        this.attachAuthentications(repositories);
        repositories.forEach(this::addProxies);
        repositories.add(0, new RemoteRepository("maven-central", "default", MAVEN_REPOSITORY).setPolicy(false, new RepositoryPolicy().setEnabled(true).setUpdatePolicy("daily")));
        repositories.forEach(r -> r.setPolicy(false, new RepositoryPolicy().setEnabled(true).setUpdatePolicy("daily")));
        this.aether = new Aether(repositories, localRepository);
    }

    public LibraryResolver(File localRepository, String id, String type, String url) {
        this.aether = new Aether(Collections.singletonList(this.addProxies(new RemoteRepository(id, type, url))), localRepository);
    }

    private void attachAuthentications(List<RemoteRepository> repositories) {
        Map<String, Server> servers = this.settings().getServers().stream().collect(Collectors.toMap(IdentifiableBase::getId, s -> s));
        for (RemoteRepository repository : repositories) {
            if (!servers.containsKey(repository.getId()) || servers.get(repository.getId()).getUsername() == null || repository.getAuthentication() != null) continue;
            Server server = servers.get(repository.getId());
            repository.setAuthentication(new Authentication(server.getUsername(), server.getPassword()));
        }
    }

    private RemoteRepository addProxies(RemoteRepository r) {
        if (System.getProperty("http.proxyHost") != null) {
            r.setProxy(new Proxy("http", System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort")), null));
        }
        return r;
    }

    public List<Artifact> resolve(Artifact root, String scope) throws DependencyResolutionException {
        return this.aether.resolve(root, scope);
    }

    public List<Artifact> resolve(Artifact root, String scope, DependencyFilter filter) throws DependencyResolutionException {
        return this.aether.resolve(root, scope, filter);
    }

    private Settings settings() {
        SettingsBuildingResult result;
        DefaultSettingsBuilder builder = new DefaultSettingsBuilderFactory().newInstance();
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        String user = System.getProperty("org.apache.maven.user-settings");
        if (user == null) {
            request.setUserSettingsFile(new File(new File(System.getProperty("user.home")).getAbsoluteFile(), "/.m2/settings.xml"));
        } else {
            request.setUserSettingsFile(new File(user));
        }
        String global = System.getProperty("org.apache.maven.global-settings");
        if (global != null) {
            request.setGlobalSettingsFile(new File(global));
        }
        try {
            result = builder.build(request);
        }
        catch (SettingsBuildingException ex) {
            throw new IllegalStateException(ex);
        }
        return this.invokers(builder, result);
    }

    private Settings invokers(SettingsBuilder builder, SettingsBuildingResult result) {
        Settings main = result.getEffectiveSettings();
        Path path = Paths.get(System.getProperty("user.dir"), "..", "interpolated-settings.xml");
        if (Files.exists(path, new LinkOption[0])) {
            DefaultSettingsBuildingRequest irequest = new DefaultSettingsBuildingRequest();
            irequest.setUserSettingsFile(path.toAbsolutePath().toFile());
            try {
                Settings isettings = builder.build(irequest).getEffectiveSettings();
                SettingsUtils.merge(isettings, main, "user-level");
                main = isettings;
            }
            catch (SettingsBuildingException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return main;
    }
}

