/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageReader;
import io.intino.cesar.datahub.ConsulTerminal;
import io.intino.cesar.datahub.events.ServerLog;
import io.intino.consul.box.AbstractBox;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.consul.box.process.ProcessLogHandler;
import io.intino.consul.box.process.ProcessManager;
import io.intino.consul.box.service.ConsulJmsService;
import io.intino.consul.graph.ConsulGraph;
import io.intino.consul.graph.Process;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.stores.FileSystemStore;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ConsulBox
extends AbstractBox {
    private ConsulJmsService jmsService;
    private ConsulGraph graph;
    private ProcessManager processManager;
    private File applicationsDirectory;
    private ProcessLogHandler processLogHandler;
    private File applicationsWorkspace;
    private String serverId = this.calculateServerId();
    private File logsDirectory;

    public ConsulBox(ConsulConfiguration configuration) {
        super(configuration);
        this.init();
    }

    private void init() {
        if (this.configuration.args().containsKey("logsDirectory")) {
            this.logsDirectory = new File(this.configuration.args().get("logsDirectory"));
        }
        this.applicationsDirectory = new File(this.configuration.args().get("applications_directory"));
        this.applicationsWorkspace = new File(this.configuration.args().getOrDefault("applications_workspace", "/home/" + this.deployUser()));
        this.processManager = new ProcessManager(this);
    }

    @Override
    public Box put(Object o) {
        if (o instanceof Graph) {
            this.graph = ((Graph)o).as(ConsulGraph.class);
            if (this.logsDirectory == null) {
                this.logsDirectory = ((FileSystemStore)this.graph().core$().store()).directory();
            }
        }
        super.put(o);
        return this;
    }

    @Override
    protected void beforeStart() {
    }

    @Override
    protected void afterStart() {
        this.processLogHandler = new ProcessLogHandler(this.serverId(), this.logsDirectory, this.terminal());
        this.jmsService = new ConsulJmsService(this.eventHub(), this);
        this.configureLogger();
    }

    @Override
    protected void beforeStop() {
    }

    @Override
    protected void afterStop() {
        Logger.info("Shutting down consul");
        this.graph.processList().forEach(p -> this.processManager.stop((Process)p));
        this.graph.processList().stream().filter(p -> this.processManager.isRunning((Process)p)).forEach(p -> this.processManager.kill((Process)p));
    }

    public ConsulGraph graph() {
        return this.graph;
    }

    public ProcessManager processManager() {
        return this.processManager;
    }

    public void processManager(ProcessManager processManager) {
        this.processManager = processManager;
    }

    public File applicationsDirectory() {
        return this.applicationsDirectory;
    }

    public File applicationsWorkspace() {
        return this.applicationsWorkspace;
    }

    public String serverId() {
        return this.serverId;
    }

    public String deployUser() {
        return this.configuration.deployUser();
    }

    public String deployGroup() {
        return this.configuration.deployGroup();
    }

    public ProcessLogHandler logHandler() {
        return this.processLogHandler;
    }

    private void configureLogger() {
        Logger.addErrorHandler(new ServerLogHandler(this.terminal()));
        Logger.addErrorHandler(new ServerLogHandler(this.terminal()));
    }

    private String calculateServerId() {
        try {
            return InetAddress.getLocalHost().getHostName().replace(".", "-");
        }
        catch (UnknownHostException e) {
            Logger.error(e.getMessage());
            return "consul-default-server";
        }
    }

    private static class ServerLogHandler
    implements Logger.LogHandler {
        private final ConsulTerminal terminal;

        ServerLogHandler(ConsulTerminal terminal) {
            this.terminal = terminal;
        }

        @Override
        public void publish(String message) {
            this.terminal.publish(new ServerLog(new MessageReader(message).next()));
        }
    }
}

