/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.event.JmsEventHub;
import io.intino.alexandria.logger.Formatter;
import io.intino.alexandria.rest.AlexandriaSparkBuilder;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.cesar.datahub.ConsulTerminal;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.consul.box.ConsulRestService;
import io.intino.consul.box.Sentinels;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends Box {
    protected ConsulConfiguration configuration;
    private JmsEventHub eventHub;
    private ConsulTerminal terminal;
    private AlexandriaScheduler scheduler = new AlexandriaScheduler();

    public AbstractBox(String[] args) {
        this(new ConsulConfiguration(args));
    }

    public AbstractBox(ConsulConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
        AlexandriaSparkBuilder.setup(Integer.parseInt("15000"), "www/");
        this.eventHub = new JmsEventHub(this.configuration().get("terminal_url"), this.configuration().get("terminal_user"), this.configuration().get("terminal_password"), this.configuration().get("terminal_clientId"), new File(this.configuration().get("terminal_working_directory")));
        this.terminal = new ConsulTerminal(this.eventHub);
    }

    @Override
    public ConsulConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public Box put(Object o) {
        return this;
    }

    protected abstract void beforeStart();

    protected abstract void afterStart();

    @Override
    public Box start() {
        this.beforeStart();
        if (this.owner != null) {
            this.owner.start();
        }
        this.initUI();
        this.initRESTServices();
        this.initJMXServices();
        this.initDatalake();
        this.initMessageHub();
        this.initTerminal();
        this.initMessagingServices();
        this.initSentinels();
        this.initSlackBots();
        this.initWorkflow();
        this.afterStart();
        return this;
    }

    @Override
    public void stop() {
        this.beforeStop();
        if (this.owner != null) {
            this.owner.stop();
        }
        AlexandriaSparkBuilder.instance().stop();
        if (this.terminal != null) {
            this.terminal.stop();
        }
        this.afterStop();
    }

    protected abstract void beforeStop();

    protected abstract void afterStop();

    public ConsulTerminal terminal() {
        return this.terminal;
    }

    protected JmsEventHub eventHub() {
        return this.eventHub;
    }

    public AlexandriaScheduler scheduler() {
        return this.scheduler;
    }

    private void initRESTServices() {
        ConsulRestService.setup(AlexandriaSparkBuilder.instance(), (ConsulBox)this).start();
        io.intino.alexandria.logger.Logger.info("REST service consul-rest: started!");
    }

    private void initMessagingServices() {
    }

    private void initJMXServices() {
    }

    private void initSlackBots() {
    }

    private void initUI() {
    }

    private void initDatalake() {
    }

    private void initMessageHub() {
    }

    private void initTerminal() {
    }

    private void initSentinels() {
        Sentinels.init(this.scheduler, (ConsulBox)this);
    }

    private void initWorkflow() {
    }

    private void initJavaLogger() {
        Logger Logger2 = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter(new Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
    }

    private URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

